<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Automaton lexer engine - Serialization
 **************************************************/

/*
 * Serialization agent (designed to be used only once).
 */
class ALE_Serializer
{
	var $symbTable = array();
	
	/*
	 * Creates a new serializer.
	 * $initSymbTable : initial symbols table.
	 */
	function ALE_Serializer($initSymbTable = array())
	{
		foreach ($initSymbTable as $n => $symb) $this->symbTable[$symb] = $n;
	}
	
	/*
	 * Launch the serialization.
	 * $data : data to serialize.
	 * returns : serialized data.
	 */
	function serialize(&$data)
	{
		return is_array($data)
			? $this->_items($data)
			: $this->_ident($data->tokenType->name)
				. $this->_string($data->relevantText())
				. $this->_properties($data->relevantProperties());
	}
	
	function _items(&$items)
	{
		$s = '#' . $this->_int(count($items));
		foreach ($items as $item) $s .= $this->serialize($item);
		return $s;
	}
	
	function _properties(&$properties)
	{
		$s = $this->_int(count($properties));
		foreach ($properties as $name => $value)
		{
			$s .= $this->_ident($name) . $this->_string($value);
		}
		return $s;
	}
	
	function _ident(&$ident)
	{
		if (isset($this->symbTable[$ident]))
		{
			return $this->_int($this->symbTable[$ident]);
		}
		$identNb = count($this->symbTable);
		$this->symbTable[$ident] = $identNb;
		return '*' . $this->_string($ident);
	}
	
	function _string(&$s)
	{
		return $this->_int(strlen($s)) . $s;
	}
	
	function _int($i)
	{
		return $i == 0 ? ':' : "$i:";
	}
}

/*
 * Deserialization agent (designed to be used only once).
 */
class ALE_Unserializer
{
	var $data = '';
	var $i = 0;
	var $symbTable = array();
	var $tokenTypes = array();
	
	/*
	 * Create a new deserialization agent.
	 * $tokenTypes : token types associative array (name -> tokenType).
	 * $data : serialized data to retrieve.
	 * $initSymbTable : initial symbols table.
	 */
	function ALE_Unserializer($tokenTypes, &$data, $initSymbTable = array())
	{
		$this->data =& $data;
		$this->tokenTypes =& $tokenTypes;
		foreach ($initSymbTable as $n => $symb) $this->symbTable[$n] = $symb;
	}
	
	/*
	 * Launch the deserialization.
	 * returns : deserialized data.
	 */
	function &unserialize()
	{
		return $this->data[$this->i] == '#'
			? $this->_array()
			: $this->_token();
	}
	
	function &_array()
	{
		$array = array();
		$this->i++;
		$nb = $this->_int();
		for ($i = 0; $i < $nb; $i++)
		{
			array_push($array, $this->unserialize());
		}
		return $array;
	}
	
	function _int()
	{
		$colon = strpos($this->data, ':', $this->i);
		$int = substr($this->data, $this->i, $colon - $this->i);
		$this->i = $colon + 1;
		return $int == '' ? 0 : $int;
	}
	
	function &_token()
	{
		$token = new ALE_Token();
		$token->tokenType =& $this->tokenTypes[$this->_ident()];
		$token->text =& $this->_string();
		$token->properties =& $this->_properties();
		return $token;
	}
	
	function &_ident()
	{
		if ($this->data[$this->i] != '*')
		{
			return $this->symbTable[$this->_int()];
		}
		$this->i++;
		$ident =& $this->_string();
		array_push($this->symbTable, $ident);
		return $ident;
	}
	
	function &_string()
	{
		$nb = $this->_int();
		$string = substr($this->data, $this->i, $nb);
		$this->i += $nb;
		return $string;
	}
	
	function &_properties()
	{
		$properties = array();
		$nb =& $this->_int();
		for ($i = 0; $i < $nb; $i++)
		{
			$ident =& $this->_ident();
			$properties[$ident] =& $this->_string();
		}
		return $properties;
		
	}
}

?>
