<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Visitors
 **************************************************/

/*
 * Visitor.
 */
/**abstract**/ class WS_Visitor
{
	/**abstract**/ function visitToken_blank(&$token) {}
	/**abstract**/ function visitToken_smiley(&$token) {}
	/**abstract**/ function visitToken_wiki(&$token) {}
	/**abstract**/ function visitToken_begintag(&$token) {}
	/**abstract**/ function visitToken_endtag(&$token) {}
	/**abstract**/ function visitToken_text(&$token) {}
	/**abstract**/ function visitToken_url(&$token) {}
	/**abstract**/ function visitToken_clock(&$token) {}
}

/*
 * XML printer.
 */
class WS_V_PrinterXml extends WS_Visitor
{
	var $out;
	
	/*
	 * Creates a new XML printer.
	 */
	function WS_V_PrinterXml()
	{
		$this->out = WS_OUT_XML;
	}
	
	function visitToken_blank(&$token)
	{
		return ' ';
	}
	
	function visitToken_smiley(&$token)
	{
		global $WS_smileyWiki;
		return ($WS_smileyWiki == '')
			? htmlspecialchars($token->string)
			: "<a href=\"$WS_smileyWiki%3a"
				.urlspecialchars($token->properties['name'])."\">"
				.htmlspecialchars($token->string)."</a>";
	}
	
	function visitToken_wiki(&$token)
	{
		global $WS_defaultWiki, $WS_wikis;
		if ($WS_defaultWiki == "") return htmlspecialchars($token->string);
		$baseUrl = isset($token->properties['site'])
			? "http://".$token->properties['site']
			: (isset($token->properties['name'])
				? $WS_wikis[$token->properties['name']]
				: $WS_defaultWiki
			);
		return "<a href=\"$baseUrl"
			.urlspecialchars($token->properties['keyword'])."\">"
			.htmlspecialchars($token->string)."</a>";
	}
	
	function visitToken_begintag(&$token)
	{
		global $WS_tagReplacements;
		$name = $token->properties['name'];
		return $token->properties['confirmed']
			? (isset($WS_tagReplacements[$this->out][$name])
				? $WS_tagReplacements[$this->out][$name][0]
				: "<$name>")
			: "&lt;$name&gt;";
	}
	
	function visitToken_endtag(&$token)
	{
		global $WS_tagReplacements;
		$name = $token->properties['name'];
		return $token->properties['confirmed']
			? (isset($WS_tagReplacements[$this->out][$name])
				? $WS_tagReplacements[$this->out][$name][1]
				: "</$name>")
			: "&lt;/$name&gt;";
	}
	
	function visitToken_text(&$token)
	{
		return htmlspecialchars($token->string);
	}
	
	function visitToken_url(&$token)
	{
		$url = isset($token->properties['url'])
			? $token->properties['url']
			: urlspecialchars($token->string);
		$title = isset($token->properties['title'])
			? $token->properties['title']
			: '[url]';
		return "<b><a href=\"$url\">$title</a></b>";
	}
	
	function visitToken_clock(&$token)
	{
		return $token->string;
	}
}

/*
 * HTML printer.
 */
class WS_V_PrinterHtml extends WS_V_PrinterXml
{
	/*
	 * Creates a new WML printer.
	 */
	function WS_V_PrinterHtml()
	{
		$this->out = WS_OUT_HTML;
	}
	function visitToken_smiley(&$token)
	{
		global $WS_smileyUrl, $WS_smileyWiki;
		$text = htmlspecialchars($token->string);
		$smiley = ($WS_smileyUrl == "")
			? $text
			: preg_replace(',%s,', rawurlencode($token->properties['name']),
				"<img src=\"$WS_smileyUrl\" "
				."alt=\"$text\" title=\"$text\"/>");
		return ($WS_smileyWiki == "")
			? $smiley
			: "<a href=\"$WS_smileyWiki%3a"
				.urlspecialchars($token->properties['name'])."\" title=\""
				.htmlspecialchars($token->string)."\">$smiley</a>";
	}
	
	function visitToken_wiki(&$token)
	{
		global $WS_defaultWiki, $WS_wikis;
		if ($WS_defaultWiki == "") return htmlspecialchars($token->string);
		$baseUrl = isset($token->properties['site'])
			? "http://".$token->properties['site']
			: (isset($token->properties['name'])
				? $WS_wikis[$token->properties['name']]
				: $WS_defaultWiki
			);
		return "<a href=\"$baseUrl"
			.urlspecialchars($token->properties['keyword'])."\" title=\""
			.htmlspecialchars($token->string)."\">"
			.htmlspecialchars($token->string)."</a>";
	}
	
	function visitToken_url(&$token)
	{
		$url = isset($token->properties['url'])
			? $token->properties['url']
			: urlspecialchars($token->string);
		$title = isset($token->properties['title'])
			? $token->properties['title']
			: '[url]';
		return "<b><a href=\"$url\" title=\"$title\">$title</a></b>";
	}
	
	function visitToken_clock(&$token) /* see rfcc40 */
	{
		global $WS_boards;
		if (!$token->properties['valid']) return $token->string;
		
		$board = '';
		$url = '';
		if (isset($token->properties['board'])
			&& isset($WS_boards[$token->properties['board']]))
		{
			$board = "-".$token->properties['board'];
			$url = $WS_boards[$token->properties['board']];
		}
		
		$clock = $clock0 = 'clock'
			.substr('0'.$token->properties['hours'], -2)
			.substr('0'.$token->properties['minutes'], -2);
		$classes = array($clock.$board => $clock.$board);
		if (isset($token->properties['seconds']))
		{
			$clock .= substr('0'.$token->properties['seconds'], -2);
			$classes[$clock.$board] = $clock.$board;
		}
		if (isset($token->properties['index']))
		{
			$index = $token->properties['index'];
			$clock .= $index;
			$classes[$clock0.$index.$board] = $clock0.$index.$board;
			$classes[$clock.$board] = $clock.$board;
		}
		
		return "<a class='_$clock ".join(' ', $classes)."' "
			."onmouseover=\"highlight('$clock$board')\" "
			."onmouseout=\"unhighlight()\" "
			."href=\"$url#$clock\">$token->string</a>";
	}
}

/*
 * WML printer.
 */
class WS_V_PrinterWml extends WS_V_PrinterXml
{
	/*
	 * Creates a new WML printer.
	 */
	function WS_V_PrinterWml()
	{
		$this->out = WS_OUT_WML;
	}
}

/* Printers array (output->visitor). */
$WS_Visitors = array(
	WS_OUT_XML => new WS_V_PrinterXml(),
	WS_OUT_HTML => new WS_V_PrinterHtml(),
	WS_OUT_WML => new WS_V_PrinterWml()
);

?>
