<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Utility functions
 **************************************************/

/*
 * Takes an array (i->item) and returns the correspounding identity
 * associative array (item->item).
 */
function &array_ident($items)
{
	$array = array();
	foreach($items as $item) $array[$item] =& $item;
	return $array;
}

/*
 * Encodes special characters within a URL.
 * $string : the string to encode.
 * returns : the encoded string.
 */
function &urlspecialchars($string)
{
	return preg_replace(
		array(',&,', ',<,', ',>,', ',",'),
		array('%26', '%3c', '%3e', '%22'),
		$string
	);
}

/*
 * Classes and ids generator for the timestamps of a board. Used for post
 * and clock highlight and anchor clocks (see rfcc40).
 */
class ClockTracker
{
	var $oldClocks = array();
	var $prevH = -1;
	var $prevM = -1;
	var $prevS = -1;
	var $prevI = 0;
	
	/*
	 * Computes the classes and anchor ids correspounding to a timestamp.
	 * $hours, $minutes, $seconds : the clock.
	 * returns an array whose first item is a string containing the classes of
	 * the timestamp (white space character separated), second one is a string
	 * containing the classes of all possible clocks referring to the
	 * timestamp (comma separated), and last one is the list of ids than refer
	 * to the timestamp.
	 * /!\ Clock classes/ids have to be computed in the chronological order of
	 * clocks.
	 */
	function getClassesAndIds($hours, $minutes, $seconds)
	{
		global $oldClocks, $prevH, $prevM, $prevS, $prevI;
		
		$h = substr("0$hours", -2);
		$m = substr("0$minutes", -2);
		$s = substr("0$seconds", -2);
		$i = ("$h$m$s" == "$prevH$prevM$prevS") ? $prevI + 1 : 1;
		
		$clocks = array(
			"clock$h$m$s$i",
			"clock$h$m$s",
			"clock$h$m$i",
			"clock$h$m"
		);
		
		$classes = join(' ', $clocks);
		
		$_clocks = array(
			"'_clock$h$m$s$i'",
			"'_clock$h$m$s'",
			"'_clock$h$m$i'",
			"'_clock$h$m'"
		);
		
		$_classes = join(', ', $_clocks);
		
		$ids = array();
		foreach ($clocks as $clock)
		{
			if (!isset($oldClocks[$clock]))
			{
				$oldClocks[$clock] = true;
				array_push($ids, $clock);
			}
		}
		
		$prevH = $h;
		$prevM = $m;
		$prevS = $s;
		$prevI = $i;
		
		return array($classes, $_classes, $ids);
	}
}

?>
