<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Automaton lexer engine - Main Classes
 **************************************************/

include(ALE_BasePath.'lexer-states.php');
include(ALE_BasePath.'lexer-transitions.php');

/*
 * Lexical analyser.
 */
class ALE_Lexer
{
	var $context;
	var $states;
	
	/*
	 * Creates a new lexer.
	 * $data : string to analyse (tokenize).
	 * $states : associative array ( statename -> state ) containing
	 * all available states.
	 */
	function ALE_Lexer(&$data, &$states)
	{
		$this->context = new ALE_Context($data);
		$this->states =& $states;
	}
	
	/*
	 * Read and returns one token (first time this function is called,
	 * analyse begins at the beging of data ; next times, analyse begins
	 * where previous analyse stopped).
	 */
	function &readToken()
	{
		$token = new ALE_Token();
		$stateName = 'init';
		$go = true;
		while ($go)
		{
			$state = $this->states[$stateName];
			list($go, $stateName) = $state->jump($this->context, $token);
		}
		$this->context->beginCursor = $this->context->endCursor;
		return $token;
	}
	
	/*
	 * Returns the list of tokens compounding whole data.
	 * $end : ending token type.
	 */
	function &readTokens(&$end)
	{
		$tokens = array();
		for ($t =& $this->readToken(); $t->tokenType != $end;
			$t =& $this->readToken())
		{
			array_push($tokens, $t);
		}
		return $tokens;
	}
}

/*
 * Token (lexical unit, characters sequence).
 */
class ALE_Token
{
	/* Token type, defined at the end of token reading. */
	var $tokenType;
	
	/* String correspounding to the token, defined at the end of token
	   reading. */
	var $string;
	
	/* Properties of the token, used by transition actions to store token
	   related data. */
	var $properties = array();
	
	/*
	 * Creates a new token.
	 */
	function ALE_Token($tokenType = null, $string = '', $properties = array())
	{
		$this->tokenType = $tokenType;
		$this->string = $string;
		$this->properties = $properties;
	}
}

/*
 * TokenType base class.
 */
class ALE_TokenType
{
	var $name;
}

/*
 * Context (encapsulates data to analyse).
 */
class ALE_Context
{
	/* Data to analyse. */
	var $data;
	
	/* Begin of the current token. */
	var $beginCursor;
	
	/* End of the current token. */
	var $endCursor;
	
	/* -- computed vars -- */
	
	/* Boolean indicating the reaching of the end of data. */
	var $endOfData;
	
	/* Current character (under the end cursor). */
	var $currentChar;
	
	/* Current string (part of the token juste before current character). */
	var $currentString;
	
	/*
	 * Creates and initialize context.
	 * $data : data to analyse.
	 */
	function ALE_Context(&$data)
	{
		$this->data =& $data;
		$this->beginCursor = 0;
		$this->endCursor = 0;
		$this->endOfData = (strlen($this->data) == 0);
		if (! $this->endOfData)
		{
			$this->currentChar = $this->data[0];
		}
		$this->currentString = '';
	}
	
	/*
	 * Consume characters (increase end cursor) and updates context.
	 * $charNb : character number to consume (usaually 0 or 1, but can take
	 * other values, even negative values to cancel previous consumption).
	 */
	function consumeChar($charNb)
	{
		if ($charNb == 0) return;
		$this->endCursor += $charNb;
		$this->endOfData = ($this->endCursor >= strlen($this->data));
		if (! $this->endOfData)
		{
			$this->currentChar = $this->data[$this->endCursor];
		}
		$this->currentString = substr($this->data, $this->beginCursor,
			$this->endCursor - $this->beginCursor);
	}
}

?>
