<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Automaton lexer engine - States
 **************************************************/

/**abstract**/ class ALE_State
{
	/*
	 * Jumps to leave current state.
	 * $context : context.
	 * $token : current token.
	 * returns ($continue, $stateName) when $continue equals true until
	 * the end of data is reached, and $stateName is the name of the new
	 * state to jump to (until the end of data is reached).
	 */
	/**abstract**/ function &jump(&$context, &$token) {}
}

/*
 * Final state.
 */
class ALE_FinalState extends ALE_State
{
	var $tokenType;
	
	/*
	 * Create a final state.
	 * $tokenType : type of the returned token when this state is reached.
	 */
	function ALE_FinalState(&$tokenType)
	{
		$this->tokenType =& $tokenType;
	}
	
	/*
	 * Finilize current token.
	 */
	function &jump(&$context, &$token)
	{
		$token->tokenType =& $this->tokenType;
		$token->string = $context->currentString;
		return array(false, null);
	}
}

/*
 * Non final state.
 */
class ALE_NonFinalState extends ALE_State
{
	var $transitions;
	
	/*
	 * Create a non final state.
	 * $endTransition : transition to apply when the end of data is reached.
	 * $alternativeTransition : transition to apply when other transitions
	 * can't be applied.
	 * $transitions : transitions sequence (the first applicable transition
	 * will be applied).
	 */
	function ALE_NonFinalState(&$endTransition, &$alternativeTransition,
		$transitions)
	{
		array_unshift($transitions, $endTransition);
		array_push($transitions, $alternativeTransition);
		$this->transitions =& $transitions;
	}
	
	/*
	 * Iterates transition sequence to find the good one, executes
	 * correspounding actions, and consume correspounding characters number.
	 */
	function &jump(&$context, &$token)
	{
		$newState = "";
		foreach($this->transitions as $transition)
		{
			if ($transition->isApplicableTo($context))
			{
				$newState =& $transition->targetState;
				foreach($transition->actions as $action)
				{
					$action($context, $token->properties);
				}
				$context->consumeChar($transition->consumption);
				break;
			}
		}
		return array(true, $newState);
	}
	
	/*
	 * Adds a transition in the head of the transitions sequence (just after
	 * the transition to apply when the end of data is reached).
	 */
	function addTransition(&$transition)
	{
		$endTransition = array_shift($this->transitions);
		array_unshift($this->transitions, $endTransition, $transition);
	}
}

?>
