<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Automaton lexer engine - Serialization
 **************************************************/

/*
 * Serialization agent (designed to be used only once).
 */
class ALE_Serializer
{
	var $symbTable = array();
	
	/*
	 * Launch the serialization.
	 * $data : data to serialize.
	 * returns : serialized data.
	 */
	function serialize(&$data)
	{
		return is_array($data)
			? '{' . count($data) . ':' . $this->_items($data) . '}'
			: $this->_ident($data->tokenType->name) . ':'
				. strlen($data->string) . ":$data->string:"
				. count($data->properties) . ':'
				. $this->_properties($data->properties);
	}
	
	function _items(&$items)
	{
		$s = '';
		foreach ($items as $item) $s .= $this->serialize($item) . ':';
		return $s;
	}
	
	function _properties(&$properties)
	{
		$s = '';
		foreach ($properties as $name => $value)
		{
			$s .= $this->_ident($name) . ':'
				. strlen($value) . ":$value" . ':';
		}
		return $s;
	}
	
	function _ident(&$ident)
	{
		if (isset($this->symbTable[$ident])) return $this->symbTable[$ident];
		$identNb = count($this->symbTable);
		$this->symbTable[$ident] = $identNb;
		return '*' . strlen($ident) . ":$ident";
	}
}

/*
 * Deserialization agent (designed to be used only once).
 */
class ALE_Unserializer
{
	var $data = '';
	var $i = 0;
	var $symbTable = array();
	var $tokenTypes = array();
	
	/*
	 * Create a new deserialization agent.
	 * $tokenTypes : token types associative array (name -> tokenType).
	 * $data : serialized data to retrieve.
	 */
	function ALE_Unserializer($tokenTypes, &$data)
	{
		$this->data =& $data;
		$this->tokenTypes =& $tokenTypes;
	}
	
	/*
	 * Launch the deserialization.
	 * returns : deserialized data.
	 */
	function &unserialize()
	{
		return $this->data[$this->i] == '{'
			? $this->_array()
			: $this->_token();
	}
	
	function &_array()
	{
		$array = array();
		$this->i++;
		$nb = $this->_int_colon();
		for ($i = 0; $i < $nb; $i++)
		{
			array_push($array, $this->unserialize());
			$this->i++;
		}
		$this->i++;
		return $array;
	}
	
	function _int_colon()
	{
		$colon = strpos($this->data, ':', $this->i);
		$int = substr($this->data, $this->i, $colon - $this->i);
		$this->i = $colon + 1;
		return $int;
	}
	
	function &_token()
	{
		$token = new ALE_Token();
		$token->tokenType =& $this->tokenTypes[$this->_ident_colon()];
		$token->string =& $this->_string();
		$this->i++;
		$token->properties =& $this->_properties();
		return $token;
	}
	
	function &_ident_colon()
	{
		if ($this->data[$this->i] != '*')
		{
			return $this->symbTable[$this->_int_colon()];
		}
		$this->i++;
		$ident =& $this->_string();
		$this->i++;
		array_push($this->symbTable, $ident);
		return $ident;
	}
	
	function &_string()
	{
		$nb = $this->_int_colon();
		$string = substr($this->data, $this->i, $nb);
		$this->i += $nb;
		return $string;
	}
	
	function &_properties()
	{
		$properties = array();
		$nb =& $this->_int_colon();
		for ($i = 0; $i < $nb; $i++)
		{
			$ident =& $this->_ident_colon();
			$properties[$ident] =& $this->_string();
			$this->i++;
		}
		return $properties;
		
	}
}

?>

