<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Utility functions
 **************************************************/

/*
 * Takes an array (i->item) and returns the correspounding identity
 * associative array (item->item).
 */
function &array_ident($items)
{
	$array = array();
	foreach($items as $item) $array[$item] =& $item;
	return $array;
}

/*
 * Encodes special characters within a URL.
 * $string : the string to encode.
 * returns the encoded string.
 */
function &urlspecialchars($string)
{
	return preg_replace(
		array(',&,', ',<,', ',>,', ',",'),
		array('%26', '%3c', '%3e', '%22'),
		$string
	);
}

?>
