<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * States
 **************************************************/

/*
 * Dynamic version of the "regex" transition, to match url begining according
 * to $WS_protocolsPattern.
 */
class WS_ProtocolsTransition extends ALE_Transition
{
	/*
	 * Create a transition applicable when current string matches the
	 * #^($WS_protocolsPattern)$# pattern.
	 * $targetState : target state name.
	 * $consumption : number of character consumed by the transition
	 * application.
	 * $actions : sequence of actions to execute juste before characters
	 * consumption.
	 */
	function WS_ProtocolsTransition($targetState, $consumption = CONS,
		$actions = array())
	{
		$this->targetState = $targetState;
		$this->consumption = $consumption;
		$this->actions =& $actions;
	}
	
	
	function isApplicableTo(&$context)
	{
		global $WS_protocolsPattern;
		return preg_match("#^($WS_protocolsPattern)$#",
			$context->currentString.$context->currentChar);
	}
}

/*
 * States associative array (statename->state).
 */
$WS_states = array(
	'init' => state(
		endOfData('end'),
		other('text0', CONS),
		array(
			char('\s', 'blank0'),
			char('\[', 'smiley-wiki'),
			char('<', 'tag', CONS, array('WS_A_tagInit')),
			char('\d', 'hour1', CONS,
				array('WS_A_clockInit', 'WS_A_clockHours'))
		)
	),
	'end' => term($WS_T_End),
	'blank0' => state(
		endOfData('blank'),
		other('blank'),
		array(
			char('\s', 'blank0')
		)
	),
	'blank' => term($WS_T_Blank),
	'smiley-wiki' => state(
		endOfData('text'),
		other('wiki0'),
		array(
			char(':', 'smiley0')
		)
	),
	'smiley0' => state(
		endOfData('text'),
		other('smiley0', CONS),
		array(
			char('\]', 'smiley', CONS, array('WS_A_smileyName'))
		)
	),
	'smiley' => term($WS_T_Smiley),
	'wiki0' => state(
		endOfData('text'),
		other('wiki0', CONS),
		array(
			char('\]', 'wiki', CONS, array('WS_A_wikiKeyword')),
			char('@', 'wikiname', CONS, array('WS_A_wikiKeyword'))
		)
	),
	'wikiname' => state(
		endOfData('text'),
		other('wiki0'),
		array(
			char('[\w-]', 'wikiname'),
			char('\.', 'wikisite'),
			char('\]', 'wiki', CONS, array('WS_A_wikiName'))
		)
	),
	'wikisite' => state(
		endOfData('text'),
		other('wiki0'),
		array(
			char('[\w-\./\?]', 'wikisite'),
			char('\]', 'wiki', CONS, array('WS_A_wikiSite'))
		)
	),
	'wiki' => term($WS_T_Wiki),
	'tag' => state(
		endOfData('text'),
		other('begintag0'),
		array(
			char('/', 'endtag0')
		)
	),
	'endtag0' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\w', 'endtag0'),
			char('>', 'endtag', CONS, array('WS_A_endtagName'))
		)
	),
	'endtag' => term($WS_T_EndTag),
	'begintag0' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\w', 'begintag0'),
			char('>', 'begintag', CONS, array('WS_A_begintagName'))
		)
	),
	'begintag' => term($WS_T_BeginTag),
	'text0' => state(
		endOfData('text'),
		other('text0', CONS),
		array(
			new WS_ProtocolsTransition('url0'),
			char('[\s\[<]', 'text', NOCONS)
		)
	),
	'text' => term($WS_T_Text),
	'url0' => state(
		endOfData('url'),
		other('url0', CONS),
		array(
			char('[\s<]', 'url', NOCONS)
		)
	),
	'url' => term($WS_T_Url),
	'hour1' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'hour2', CONS, array('WS_A_clockHours')),
			char('[:h]', 'min0')
		)
	),
	'hour2' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'min1a', CONS, array('WS_A_clockMinutes')),
			char('[:h]', 'min0')
		)
	),
	'min0' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'min1', CONS, array('WS_A_clockMinutes'))
		)
	),
	'min1' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'min2', CONS, array('WS_A_clockMinutes')),
		)
	),
	'min2' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char(':', 'sec0'),
			char('m', 'sec0a'),
			char('[]', 'index1', CONS, array('WS_A_clockIndexExp')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'sec0a' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char('\d', 'sec1', CONS, array('WS_A_clockSeconds')),
			char('[]', 'index1', CONS, array('WS_A_clockIndexExp')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'sec0' => state(
		endOfData('clock', -1),
		other('clock', -1),
		array(
			char('\d', 'sec1', CONS, array('WS_A_clockSeconds')),
		)
	),
	'sec1' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'sec2', CONS, array('WS_A_clockSeconds')),
		)
	),
	'sec2' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char(':', 'index0'),
			char('s', 'index0a'),
			char('[]', 'index1', CONS, array('WS_A_clockIndexExp')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'index0a' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char('\d', 'index1', CONS, array('WS_A_clockIndex')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'index0' => state(
		endOfData('clock', -1),
		other('clock', -1),
		array(
			char('\d', 'index1', CONS, array('WS_A_clockIndex'))
		)
	),
	'index1' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'board0' => state(
		endOfData('clock', -1),
		other('clock', -1),
		array(
			char('\w', 'board1')
		)
	),
	'board1' => state(
		endOfData('clock', NOCONS, array('WS_A_clockBoardEnd')),
		other('clock', NOCONS, array('WS_A_clockBoardEnd')),
		array(
			char('\w', 'board1'),
			char('-', 'sub0', CONS, array('WS_A_clockBoardEnd'))
		)
	),
	'sub0' => state(
		endOfData('clock', -1),
		other('clock', -1),
		array(
			char('\d', 'clock', CONS, array('WS_A_clockSub'))
		)
	),
	'min1a' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'min2a', CONS, array('WS_A_clockMinutes'))
		)
	),
	'min2a' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char('\d', 'sec1a', CONS, array('WS_A_clockSeconds')),
			char(':', 'index0'),
			char('[]', 'index1', CONS, array('WS_A_clockIndexExp')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'sec1a' => state(
		endOfData('text'),
		other('text'),
		array(
			char('\d', 'sec2a', CONS, array('WS_A_clockSeconds'))
		)
	),
	'sec2a' => state(
		endOfData('clock'),
		other('clock'),
		array(
			char(':', 'index0'),
			char('[]', 'index1', CONS, array('WS_A_clockIndexExp')),
			char('@', 'board0', CONS, array('WS_A_clockBoardBegin')),
			char('-', 'sub0')
		)
	),
	'clock' => term($WS_T_Clock)
);

?>
