<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Actions
 **************************************************/

/* Begining of the "site" part of extended wiki links. */
$WS_A_wikiSiteBegin = 0;

/*
 * Action executed after reading a wiki keyword.
 */
function WS_A_wikiKeyword(&$context, &$properties)
{
	global $WS_A_wikiSiteBegin;
	$WS_A_wikiSiteBegin = $context->endCursor + 1;
	$properties['keyword'] = substr($context->currentString, 1);
}

/*
 * Action executed after reading a wiki name.
 */
function WS_A_wikiName(&$context, &$properties)
{
	global $WS_A_wikiSiteBegin, $WS_wikis;
	$name = substr($context->data, $WS_A_wikiSiteBegin,
		$context->endCursor - $WS_A_wikiSiteBegin);
	if (isset($WS_wikis[$name]))
	{
		$properties['name'] = $name;
	} else
	{
		$properties['keyword'] = substr($context->currentString, 1);
	}
	
}

/*
 * Action executed after reading a wiki base url.
 */
function WS_A_wikiSite(&$context, &$properties)
{
	global $WS_A_wikiSiteBegin;
	$properties['site'] = substr($context->data, $WS_A_wikiSiteBegin,
		$context->endCursor - $WS_A_wikiSiteBegin);
}

/*
 * Action executed after reading a smiley url.
 */
function WS_A_smileyName(&$context, &$properties)
{
	$properties['name'] = substr($context->currentString, 2);
}

/*
 * Action executed before reading a tag.
 */
function WS_A_tagInit(&$context, &$properties)
{
	$properties['confirmed'] = false;
}

/* Unconfirmed begin tags. */
$WS_A_beginTags = array();

/*
 * Action executed after reading an opening tag.
 */
function WS_A_begintagName(&$context, &$properties)
{
	global $WS_A_beginTags, $WS_allowedTags;
	$properties['name'] = substr($context->currentString, 1);
	if (!isset($WS_allowedTags[$properties['name']])) return;
	array_push($WS_A_beginTags, &$properties);
}

/*
 * Action executed after reading a closing tag.
 */
function WS_A_endtagName(&$context, &$properties)
{
	global $WS_A_beginTags, $WS_allowedTags;
	$properties['name'] = substr($context->currentString, 2);
	if (!isset($WS_allowedTags[$properties['name']])) return;
	for ($i = count($WS_A_beginTags) - 1; $i >= 0; $i--)
	{
		if ($WS_A_beginTags[$i]['name'] == $properties['name'])
		{
			$properties['confirmed'] = true;
			$WS_A_beginTags[$i]['confirmed'] = true;
			array_splice($WS_A_beginTags, $i);
			break;
		}
	}
}

/*
 * Action executed before reading a clock.
 */
function WS_A_clockInit(&$context, &$properties)
{
	$properties['hours'] = 0;
	$properties['minutes'] = 0;
	$properties['valid'] = true;
}

/*
 * Action executed when reading an hour digit.
 */
function WS_A_clockHours(&$context, &$properties)
{
	$properties['hours'] = $properties['hours'] * 10 + $context->currentChar;
	$properties['valid'] &= $properties['hours'] < 24;
}

/*
 * Action executed when reading a minute digit.
 */
function WS_A_clockMinutes(&$context, &$properties)
{
	$properties['minutes'] = $properties['minutes'] * 10
		+ $context->currentChar;
	$properties['valid'] &= $properties['minutes'] < 60;
}

/*
 * Action executed when reading a second digit.
 */
function WS_A_clockSeconds(&$context, &$properties)
{
	$properties['seconds'] = (!isset($properties['seconds']))
		? $context->currentChar
		: $properties['seconds'] * 10 + $context->currentChar;
	$properties['valid'] &= $properties['seconds'] < 60;
}

/*
 * Action executed when reading the index digit.
 */
function WS_A_clockIndex(&$context, &$properties)
{
	$properties['index'] = $context->currentChar;
}

/*
 * Action executed when reading the index superscript digit.
 */
function WS_A_clockIndexExp(&$context, &$properties)
{
	$properties['index'] = strrpos("", $context->currentChar) + 1;
}

/* Begining of the "board" part of a clock. */
$WS_A_clockBoardBegin = 0;

/*
 * Action executed before reading the board part of a clock.
 */
function WS_A_clockBoardBegin(&$context, &$properties)
{
	global $WS_A_clockBoardBegin;
	$WS_A_clockBoardBegin = $context->endCursor + 1;
}

/*
 * Action executed after reading the board part of a clock.
 */
function WS_A_clockBoardEnd(&$context, &$properties)
{
	global $WS_A_clockBoardBegin, $WS_boards, $WS_myNames;
	$properties['board'] = substr($context->data, $WS_A_clockBoardBegin,
		$context->endCursor - $WS_A_clockBoardBegin);
	$properties['valid'] &= isset($WS_boards[$properties['board']])
		 || isset($WS_myNames[$properties['board']]);
}

/*
 * Action executed when reading the subcomment digit.
 */
function WS_A_clockSub(&$context, &$properties)
{
	$properties['sub'] = $context->currentChar;
}

?>
