<?php
/*
 * chouchenn wonderslip
 * Copyright (c) 2004 olo <wonderslip at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Automaton lexer engine - Shortcuts
 **************************************************/

include("lib/lexer.php");

/*
 * Most frequent values for characters consumption during a transition.
 */
define("NOCONS", 0);
define("CONS", 1);

/*
 * Create a final state.
 * $tokenType : type of the returned token when this state is reached.
 */
function &term(&$tokenType)
{
	return new ALE_FinalState($tokenType);
}

/*
 * Create a non final state.
 * $endTransition : transition to apply when the end of data is reached.
 * $alternativeTransition : transition to apply when othes transitions can't
 * be applied.
 * $transitions : transitions sequence (the first applicable transition will
 * be applied).
 */
function &state(&$endTransition, &$alternativeTransition, $transitions)
{
	return new ALE_NonFinalState($endTransition, $alternativeTransition,
		$transitions);
}

/*
 * Create an alternative transition, always applicable.
 * $targetState : target state name.
 * $consumption : number of character consumed by the transition application.
 * $actions : sequence of actions to execute juste before characters
 * consumption.
 */
function &other($targetState, $consumption = NOCONS, $actions = array())
{
	return new ALE_AlternativeTransition($targetState, $consumption,
		$actions);
}

/*
 * Create a final transition, applicable when the end of data is reached.
 * $targetState : target state name.
 * $consumption : number of character consumed by the transition application.
 * $actions : sequence of actions to execute juste before characters
 * consumption.
 */
function &endOfData($targetState, $consumption = NOCONS, $actions = array())
{
	return new ALE_EndTransition($targetState, $consumption, $actions);
}

/*
 * Create a "character" transition, applicable when current character belongs
 * to a given class.
 * $charClass : character class ("preg" regex form, '\w' or '[\d\.-]', for
 * example).
 * $targetState : target state name.
 * $consumption : number of character consumed by the transition application.
 * $actions : sequence of actions to execute juste before characters
 * consumption.
 */
function &char($charClass, $targetState, $consumption = CONS,
	$actions = array())
{
	return new ALE_CharTransition($charClass, $targetState, $consumption,
		$actions);
}

/*
 * Create a "regex" transition, applicable when current string matches a given
 * pattern.
 * $pattern : pattern to match ("preg" regex form, '#^(coin|pan)$#', for
 * example).
 * $targetState : target state name.
 * $consumption : number of character consumed by the transition application.
 * $actions : sequence of actions to execute juste before characters
 * consumption.
 */
function &matches($pattern, $targetState, $consumption = CONS,
	$actions = array())
{
	return new ALE_RegexTransition($pattern, $targetState, $consumption,
		$actions);
}

?>
