<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Message post
 **************************************************/

include("lib/commons.php");
include("lib/httpclient.php");
include("lib/cookies.php");
include("lib/nxpt.class.php");
include("./config.php");

//$board = getBoardName($HTTP_GET_VARS, $boards);
$board = getBoardName($HTTP_POST_VARS, $boards);
$message = unescape($HTTP_POST_VARS["message"]);

list($httpVersion, $statusCode, $statusMessage, $headers, $content) = httpPost(
	$boards[$board]->post_url,
	preg_replace(",%s,", rawurlencode($message), $boards[$board]->postData),
	"application/x-www-form-urlencoded",
	getUa($_SERVER, $HTTP_COOKIE_VARS, $board),
	$boards[$board]->backend_url,
	selectCookiesForBoard($board, $boards[$board]->cookies, $HTTP_COOKIE_VARS)
);
/*
echo "httpVersion : $httpVersion\n";
echo "code : $statusCode\n";
echo "message : $statusMessage\n";
echo "headers :\n";
foreach($headers as $headerName => $headerValue) echo " $headerName => $headerValue\n";
echo "content : $content\n";
*/

wmlHeader();

$nxpt = new nxpt;
$nxpt->nxpt_cache_path("cache");
$nxpt->assign("board", $board);
$nxpt->assign("message", encodeXML($message));
//$nxpt->assign("message", $message);
$nxpt->assign("statusCode", encodeXML($statusCode));
$nxpt->assign("statusMessage", encodeXML($statusMessage));
$nxpt->assign("content", encodeXML($content));
$nxpt->display("template/post.xml");

?>
