<?php
/*
* Copyright (c) 2004 2xplop <2xplop at bluewin.ch>
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this
* software and associated documentation files (the "Software"), to deal in the Software
* without restriction, including without limitation the rights to use, copy, modify, merge,
* publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
* to whom the Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or substantial
* portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
* FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

class nxpt_process {

	var $templates_include;
	var $nxpt_compiler;

	function nxpt_process() {
		$this->templates_include = array();
		$this->nxpt_compiler = new nxpt_compiler;
	}

	function nxpt_process_template($template_name, $nxpt_config) {
		/*Et hop, un joli petit travail a faire :o*/
		array_push($this->templates_include, $template_name);
		while (list ( , $template_name) = each($this->templates_include)) {
			$nxpt_template = new nxpt_template;
			$nxpt_template->template_absolute_path = $template_name;
			$nxpt_template->nxpt_cache_path = $nxpt_config->nxpt_cache_path;
			$this->nxpt_compiler->process($nxpt_template, '');
			$nxpt_template = $this->nxpt_compiler->nxpt_template;
			$this->_nxpt_process_add_include($nxpt_template->template_include);
			$this->_nxpt_save_template($nxpt_template, '');
		}
	}

	function _nxpt_process_add_include($include_array) {
		foreach ($include_array as $template_path) {
			if (!in_array($template_path, $this->templates_include)) {
				array_push($this->templates_include, $template_path);
			}
		}
	}

	function _nxpt_save_template($template, $charset_out) {
		$template_name = $template->nxpt_cache_path.nxpt_utils::replace_slash_dot($template->template_absolute_path).'-compiled';
		$file_compiled_template = fopen($template_name, 'w');
		fwrite($file_compiled_template, $template->template_compiled);
		fclose($file_compiled_template);
	}
}
/*********************************************************************/
class nxpt_template {

	var $template_absolute_path;
	var $nxpt_cache_path;
	var $template_include;
	var $template_compiled;

	function nxpt_template() {
		$this->template_include = array();
		$this->template_compiled = '';
	}
}
/*********************************************************************/
class nxpt_compiler {
	var $nxpt_compiler_xml_parser;
	var $nxpt_template;
	var $vars_arr;
	var $locks;
	//----- oui, c'est gorait... :-/ TODO: les virer [:gratgrat]
	var $nxpt_print_open;
	var $nxpt_is_void_element;
	var $nxpt_is_after_open_element;
	//-----

	function nxpt_compiler() {
		$this->vars_arr = array('foreach_var' => array(),'redirect_output'=>array('template'),'set_var'=>array());
		$this->locks = array('compiler_w_c_o_lock' => false, 'strip_whitespace' => 'false');
		$this->nxpt_print_open = false;
		$this->nxpt_is_void_element = false;
		$this->nxpt_is_after_open_element = false;
	}

	function process($nxpt_template, $charset_in) {
		$this->nxpt_template = $nxpt_template;
		$this->nxpt_template->template_compiled .= '<?php ';
		$this->compile_template($charset_in);
		xml_parser_free($this->nxpt_compiler_xml_parser);
		$this->nxpt_template->template_compiled .= '?>';
		$this->nxpt_compiler();
	}

	function compile_template($charset_in) {
		$template = $this->nxpt_template->template_absolute_path;
		$this->nxpt_compiler_xml_parser = xml_parser_create('ISO-8859-1');
		xml_set_object($this->nxpt_compiler_xml_parser, $this);
		xml_parser_set_option($this->nxpt_compiler_xml_parser, XML_OPTION_CASE_FOLDING, false);
		xml_set_element_handler($this->nxpt_compiler_xml_parser, 'startElement', 'endElement');
		xml_set_character_data_handler($this->nxpt_compiler_xml_parser, 'characterData');
		if (!($fp = fopen($this->nxpt_template->template_absolute_path, 'r'))) {
			die(nxpt_errors::error('Input', 'Could not open XML input', $template));
		}
		while ($data = fread($fp, 4096)) {
			$data = str_replace('&', '&amp;', $data);
			if (!xml_parse($this->nxpt_compiler_xml_parser, $data, feof($fp))) {
				$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
				$error_message = xml_error_string(xml_get_error_code($this->nxpt_compiler_xml_parser)).' at line '.$line;
				die(nxpt_errors::error('XML error', $error_message, $template));
			}
		}
	}

	function create_element($name,$attrs) {
		$nxpt_element = array();
		$nxpt_element['name'] = $name;
		$nxpt_element['attrs'] = $attrs;
		$nxpt_element['line'] = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$nxpt_element['template_name']= $this->nxpt_template->template_absolute_path;
		$nxpt_element['vars_arr'] = $this->vars_arr;
		$nxpt_element['locks'] = $this->locks;
		$nxpt_element['template_include'] = $this->nxpt_template->template_include;
		$nxpt_element['template_compiled'] = '';
		return $nxpt_element;
	}

	function get_data($data) {
		$this->nxpt_template->template_compiled .= $data['template_compiled'];
		$this->locks = $data['locks'];
		$this->vars_arr = $data['vars_arr'];
		$this->nxpt_template->template_include = $data['template_include'];
	}

	function startElement($parser, $name, $attrs) {
		$nxpt_element = $this->create_element($name,$attrs);
		$this->locks['compiler_w_c_o_lock'] = false;
		//  on peut le faire a coup d'explode :o
		if (!preg_match('/^nxpt:/', $name)) {
			if($this->nxpt_is_after_open_element == true) {
				$this->nxpt_template->template_compiled .= '>';
			}
			$this->nxpt_is_after_open_element = true;
			$this->nxpt_is_void_element = true;
			if($this->nxpt_print_open == false) {
				$this->nxpt_template->template_compiled .= '$'.end($this->vars_arr['redirect_output']).' .= \'';
				$this->nxpt_print_open = true;
			}
			$this->_non_nxpt_element_start($nxpt_element);
		} else {
			if($this->nxpt_is_void_element == true) {
				$this->nxpt_template->template_compiled .= '>';
				$this->nxpt_is_void_element = false;
			}
			if($this->nxpt_print_open == true) {
				$this->nxpt_template->template_compiled .= '\';';
				$this->nxpt_print_open = false;
			}
			// TODO, systeme d'erreur /!\
			$element_name_array = explode(':',$name);
			$element_name = $element_name_array[1];
			$data = call_user_func('nxptCore_'.$element_name.'_start',$nxpt_element);
			$this->get_data($data);
		}
	}

	function endElement($parser, $name) {
		$this->locks['compiler_w_c_o_lock'] = false;
		if (!preg_match('/^nxpt:/', $name)) {
			$this->nxpt_is_after_open_element = false;
			if($this->nxpt_print_open == true) {
				if($this->nxpt_is_void_element == true) {
					$this->nxpt_template->template_compiled .= ' />';
					$this->nxpt_is_void_element = false;
				} else {
					$this->nxpt_template->template_compiled .= '</'.$name.'>';
				}
			} else {
				$this->nxpt_template->template_compiled .='$'.end($this->vars_arr['redirect_output']).'.= \'</'.$name.'>';
				$this->nxpt_print_open = true;
			}
		} else {
			if($this->nxpt_print_open == true) {
				$this->nxpt_template->template_compiled .= '\';';
				$this->nxpt_print_open = false;
			}
			$attrs = array();
			$nxpt_element = $this->create_element($name,$attrs);
			// TODO, systeme d'erreur /!\
			$element_name_array = explode(':',$name);
			$element_name = $element_name_array[1];
			$data = call_user_func('nxptCore_'.$element_name.'_end',$nxpt_element);
			$this->get_data($data);
		}
	}

	function characterData($parser, $data) {
		//je sais, c'est vilain...
		$this->nxpt_is_after_open_element = false;
		if($this->locks['compiler_w_c_o_lock'] == false) {
			if($this->nxpt_is_void_element == true) {
				$this->nxpt_template->template_compiled .= '>';
			}
			$this->nxpt_is_void_element = false;
			$data = nxpt_process_utils::add_slashouille($data);
			if($this->nxpt_print_open == false) {
				$this->nxpt_template->template_compiled .= '$'.end($this->vars_arr['redirect_output']).' .= \'';
				$this->nxpt_print_open = true;
			}
			//un'autre systeme ?
			if($this->locks['strip_whitespace'] == 'false') {
				$this->nxpt_template->template_compiled .= $data;
			} else {
				if(preg_match('/\t*\n/',$data)) {
				} else {
					$this->nxpt_template->template_compiled .= str_replace("\t\t",'',$data);
				}
				//if(preg_match('/[\n\r\f]+/',$data)) {
				//} else {
				//	$this->nxpt_template->template_compiled .= trim($data,"\t");
				//}
			}
		}
	}

	function _non_nxpt_element_start($element) {
		$vars_arr = $this->vars_arr;
		$this->nxpt_template->template_compiled .= '<'.$element['name'];
		foreach ($element['attrs'] as $key => $value) {
			$value = nxpt_process_utils::add_slashouille($value);
			//TODO: a controler que a ne bugge pas, mais a sux toujours, on ne peut pas mettre $,{,} dans les 'string' :-/...
			if(preg_match_all('/\${([^{}$]+)}/',$value,$matches)) {
				foreach ($matches[1] as $expression) {
					$value = str_replace('${'.$expression.'}','\'.'.nxpt_expression::expression($expression,$vars_arr).'.\'', $value);
				}
			}
			$this->nxpt_template->template_compiled .=' '.$key.'="'.$value.'"';
		}
	}
}

/*********************************************************************/

class nxpt_process_utils {

	function add_slashouille($data) { return str_replace('\'', '\\\'', $data);}

	function attr_test($element) {
		$vars_arr = $element['vars_arr'];
		$expression = nxpt_process_utils::check_attr_e($element, 'test');
		$expression = nxpt_process_utils::add_slashouille($expression);
		return nxpt_expression::expression($expression, $vars_arr);
	}

	function check_attr($element,$key) {
		if(array_key_exists($key, $element['attrs'])) {
			return $element['attrs'][$key];
		} else {
			$error_type = 'attribute error';
			$error_message = nxpt_errors::attribute_msg($key, $element['name'], $element['line']);
			die(nxpt_errors::error($error_type, $error_message, $element['template_name']));
		}
	}

	function check_attr_e($element, $key) {
			$expression = nxpt_process_utils::check_attr($element, $key);
			return nxpt_expression::get_expression($expression);
	}
}

/*********************************************************************/

class nxpt_errors {

	function error($type, $error, $template) {
		return '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>nxpt  error</title>
<style type="text/css">
html,body {margin:0;font-family:sans-serif}
h1{background-color:#9EB5C7;margin:0;margin-bottom:0.5em; border-bottom:1px dotted black}
p span {font-weight:bold;margin-left:0.5em; padding:2px;} p {margin:0;padding-bottom:1em;}
</style>
</head>
<body>
<h1>&lt;nxpt/&gt; error</h1>
<p><span>template:</span> '.$template.'</p>
<p><span>type:</span> '.$type.'</p>
<p><span>message:</span> '.$error.'</p>
</body>
</html>';
	}

	function attribute_msg($attribute, $tag_name, $line) {
		return 'required attribute \''.$attribute.'\' not specified in &lt;'.$tag_name.'/&gt; at line '.$line;
	}
}

/*********************************************************************/
require_once('Expression.php');
require_once('Core.php');
/*********************************************************************/

?>
