<?php
/*
* Copyright (c) 2004 2xplop <2xplop at bluewin.ch>
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this
* software and associated documentation files (the "Software"), to deal in the Software
* without restriction, including without limitation the rights to use, copy, modify, merge,
* publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
* to whom the Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or substantial
* portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
* FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

/*
exemple de fonction
function nxptCore_comment_start($element) {
	$element['template_compiled'] = '$'.end($element['vars_arr']['redirect_output']).'  .=\'<!--\';';
	return $element;
}

function nxptCore_comment_end($element) {
	$element['template_compiled'] = '$'.end($element['vars_arr']['redirect_output']).'  .=\'-->\';';
	return $element;
}
*/

/*** nxpt:template ***/
function nxptCore_template_start($element) {
	if(array_key_exists('stripwhitespace',$element['attrs'])) {
		$valeur_attribut = $element['attrs']['stripwhitespace'];
		if($valeur_attribut != 'true' && $valeur_attribut != 'false') {
			$error_message = 'valeur doit etre true ou false, pas '.$valeur_attribut;
			die(nxpt_errors::error('attribut stripwhitespace', $error_message, $element['template_name']));
		}
		$element['locks']['strip_whitespace'] = $valeur_attribut;
	}
	return $element;
}

function nxptCore_template_end($element) {
	return $element;
}
/****************/

/*** nxpt:out ***/
function nxptCore_out_start($element) {
	$vars_arr = $element['vars_arr'];
	$expression = nxpt_process_utils::add_slashouille(nxpt_process_utils::check_attr_e($element, 'value'));
	$element['template_compiled'] = '$'.end($element['vars_arr']['redirect_output']).'.= '.nxpt_expression::expression($expression,$vars_arr).';';
	return $element;
}

function nxptCore_out_end($element) {
	return $element;
}
/****************/

/*** nxpt:if ***/
function nxptCore_if_start($element) {
	$expression = nxpt_process_utils::attr_test($element);
	$element['template_compiled'] = 'if('.$expression.') {';
	return $element;
}

function nxptCore_if_end($element) {
	return $element;
}
/****************/

/*** nxpt:then ***/
function nxptCore_then_start($element) {
	return $element;
}

function nxptCore_then_end($element) {
	$element['template_compiled'] = '}';
	$element['locks']['compiler_w_c_o_lock'] = true;
	return $element;
}
/****************/

/*** nxpt:else ***/
function nxptCore_else_start($element) {
	$element['locks']['compiler_w_c_o_lock'] = false;
	$element['template_compiled'] = 'else {';
	return $element;
}

function nxptCore_else_end($element) {
	$element['template_compiled'] = '}';
	return $element;
}
/****************/

/*** nxpt:choose ***/
function nxptCore_choose_start($element) {
	$element['locks']['compiler_w_c_o_lock'] = true;
	$element['template_compiled'] = 'if(false) {}';
	return $element;
}

function nxptCore_choose_end($element) {
	return $element;
}
/****************/

/*** nxpt:when ***/
function nxptCore_when_start($element) {
	$element['locks']['compiler_w_c_o_lock'] = false;
	$expression = nxpt_process_utils::attr_test($element);
	$element['template_compiled'] = 'elseif('.$expression.') {';
	return $element;
}

function nxptCore_when_end($element) {
	$element['locks']['compiler_w_c_o_lock'] = true;
	$element['template_compiled'] = '}';
	return $element;
}
/****************/

/*** nxpt:otherwise ***/
function nxptCore_otherwise_start($element) {
	$element['locks']['compiler_w_c_o_lock'] = false;
	$element['template_compiled'] = 'else {';
	return $element;
}

function nxptCore_otherwise_end($element) {
	$element['locks']['compiler_w_c_o_lock'] = true;
	$element['template_compiled'] = '}';
	return $element;
}
/****************/

/*** nxpt:foreach ***/
function nxptCore_foreach_start($element) {
	$begin = nxpt_process_utils::check_attr_e($element, 'begin');
	$end = nxpt_process_utils::check_attr_e($element, 'end');
	$var = nxpt_process_utils::check_attr_e($element, 'var');
	array_push($element['vars_arr']['foreach_var'], $var);
	$vars_arr = $element['vars_arr'];
	$begin = nxpt_expression::expression($begin,$vars_arr);
	$end = nxpt_expression::expression($end,$vars_arr);
	$element['template_compiled'] = 'for($'.$var.'='.$begin.';$'.$var.'<'.$end.';$'.$var.'++){';
	return $element;
}

function nxptCore_foreach_end($element) {
	array_pop($element['vars_arr']['foreach_var']);
	$element['template_compiled'] = '}';
	return $element;
}
/****************/

/*** nxpt:break ***/
function nxptCore_break_start($element) {
	$element['template_compiled'] ='break;';
	return $element;
}

function nxptCore_break_end($element) {
	return $element;
}
/****************/

/*** nxpt:next ***/
function nxptCore_next_start($element) {
	$element['template_compiled'] = 'continue;';
	return $element;
}

function nxptCore_next_end($element) {
	return $element;
}
/****************/

/*** nxpt:set ***/
function nxptCore_set_start($element) {
	$value = '';
	$var = nxpt_process_utils::check_attr_e($element, 'var');
	array_push($element['vars_arr']['set_var'], $var);
	$vars_arr = $element['vars_arr'];
	if(array_key_exists('value',$element['attrs'])) {
		$value = nxpt_expression::get_expression($element['attrs']['value']);
		$value = nxpt_expression::expression($value, $vars_arr);
		$element['template_compiled'] = '$'.$var.'='.$value.';';
	} else {
		$element['template_compiled'] = '$'.$var.'= \'\';';
	}
	return $element;
}

function nxptCore_set_end($element) {
	return $element;
}
/****************/

/*** nxpt:remove ***/
function nxptCore_remove_start($element) {
	$var = nxpt_process_utils::check_attr_e($element, 'var');
	if(in_array($var, $element['vars_arr']['set_var'])) {
		$key = array_search($var,$element['vars_arr']['set_var']);
		unset($element['vars_arr']['set_var'][$key]);
	}
	return $element;
}

function nxptCore_remove_end($element) {
	return $element;
}
/****************/

/*** nxpt:include ***/
function nxptCore_include_start($element) {
	$template_name = $element['template_name'];
	$template = nxpt_process_utils::check_attr($element, 'template');
	$path_parts = pathinfo($template_name);
	$path_include = realpath($path_parts['dirname'].'/'.$template);
	if(!file_exists($path_include)) {
		$error_type = 'included template';
		$error_message = $path_parts['dirname'].'/'.$template.' n\'existe pas (ligne '.$element['line'].')';
		$template = $this->nxpt_template->template_absolute_path;
		die(nxpt_errors::error($error_type, $error_message, $template_name));
	}
	if(!in_array($path_include, $element['template_include'])) {
		array_push($element['template_include'], $path_include);
	}
	$path_include = nxpt_utils::replace_slash_dot($path_include).'-compiled';
	$element['template_compiled'] = 'include(\''.$path_include.'\');';
	return $element;
}

function nxptCore_redirectoutput_end($element) {
	array_pop($element['vars_arr']['redirect_output']);
	return $element;
}
/****************/

/*** nxpt:redirectoutput ***/
function nxptCore_redirectoutput_start($element) {
	$var = nxpt_process_utils::check_attr_e($element, 'var');
	array_push($element['vars_arr']['redirect_output'], $var);
	return $element;
}

function nxptCore_include_end($element) {
	return $element;
}
/****************/

?>
