<?php
/*
* Copyright (c) 2004 2xplop <2xplop at bluewin.ch>
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this
* software and associated documentation files (the "Software"), to deal in the Software
* without restriction, including without limitation the rights to use, copy, modify, merge,
* publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
* to whom the Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or substantial
* portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
* FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

class nxpt_config {
	//le path du repertoire de cache (absolu!)
	var $nxpt_cache_path = '';
}

class nxpt {
	var $nxpt_assigned_data;
	var $nxpt_template;
	var $nxpt_config;

	function nxpt() {
		$this->nxpt_config = new nxpt_config;
		$this->nxpt_assigned_data = array();
	}
	
	function assign($nxpt_from_php_assigned_name, $nxpt_from_php_assigned_data) {
		$this->nxpt_assigned_data[$nxpt_from_php_assigned_name] = $nxpt_from_php_assigned_data;
	}

	function nxpt_cache_path($nxpt_cache_path) {
		$this->nxpt_config->nxpt_cache_path = realpath($nxpt_cache_path).'/';
	}

	function ikan($nxpt_from_php_template) {
		$this->nxpt_template = realpath($nxpt_from_php_template);
		return $this->check_cache($this->nxpt_template, $this->nxpt_config);
	}

	function display($nxpt_from_php_template) {
		print $this->ikan($nxpt_from_php_template);
	}

	function check_cache($nxpt_template, $nxpt_config) {
		$compiled_template = $nxpt_config->nxpt_cache_path.nxpt_utils::replace_slash_dot($nxpt_template).'-compiled';
		$template = '';
		if (file_exists($compiled_template) && (filemtime($compiled_template) > filemtime($nxpt_template))) {
			include ($compiled_template);
			return $template;
		} else {
			require_once ('nxpt_lib/NxptCompiler.class.php');
			$nxpt_process = new nxpt_process;
			$nxpt_process->nxpt_process_template($nxpt_template, $nxpt_config);
			include ($compiled_template);
			return $template;
		}
	}
}

class nxpt_utils {

	function replace_slash_dot($path) {
		//update pour windows :o
		return str_replace(':','_',str_replace('\\','_',str_replace('.', '_', str_replace('/', '_', $path))));
	}

	function out_assigned_data($value, $default_attr) {
		if (array_key_exists($value, $this->nxpt_assigned_data)) {
				return $this->nxpt_assigned_data[$value];
		} else {
			return $default_attr;
		}
	}
}
?>
