<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Basic HTTP client
 **************************************************/

 /*
  * parseUrl : parses an URL
  * $url : the URL to parse
  * returns : ($host, $port, $path)
  */
function parseUrl($url) {
	if (! preg_match(',^http://(.+?)(:(\d+))?(/.*)$,', $url, $parts)) {
		die("httpGet - bad url : $url\n");
	}
	list(, $host, , $port, $path) = $parts;
	if ($port == "") {
		$port = 80;
	}
	return array($host, $port, $path);
}

/*
 * commonHeaders : computes common headers of an HTTP (GET or POST) request
 * $host : hostname of the URL
 * $port : port number of the URL
 * $ua : user agent
 * $referer : referer URL
 * $cookies : associative array {cookie name => cookie value}
 * returns : a string containing headers (each one is preceded by \r\n)
 */
function commonHeaders($host, $port, $ua, $referer, $cookies) {
	$headers = "\r\nHost: $host";
	if ($port != 80) $headers .= ":$port";
	$headers .= "\r\nConnection: close";
	$headers .= "\r\nCache-Control: no-cache";
	$headers .= "\r\nUser-Agent: $ua";
	if ($referer != "") $headers .= "\r\nReferer: $referer";
	$firstcookie = true;
	reset($cookies);
	while (list($name, $value) = each($cookies)) {
		if ($firstcookie) {
			$headers .= "\r\nCookie: $name=$value";
			$firstcookie = false;
		} else {
			$headers .= ";$name=$value";
		}
	}
	return $headers;
}

/*
 * connexion : TCP connexion (sends the HTTP request and receive the HTTP response)
 * $host : peer hostname
 * $port : port number
 * $request : HTTP request
 * returns : HTTP response
 */
function connexion($host, $port, $request) {
	$fh = fsockopen($host, $port);
	if(!$fh) {
		die("httpGet - unable to connect to $host:$port\n");
	}
	fputs($fh, $request);
	$response = "";
	$buf = "";
	while (!feof($fh)) {
		$buf = fgets($fh, 256);
		$response .= $buf;
	}
	fclose($fh);
	return $response;
}

/*
 * parseResponse : parses an HTTP response
 * $response : the HTTP response
 * returns : (response http version, status code, status message,
 *             associative array {header name => header value}, response content)
 */
function parseResponse($response) {
	if (! preg_match(',^HTTP/(.+?) (\d+) (.+?)\r\n((.+?\r\n)*?)\r\n(.*)$,s', $response, $parts)) {
		die("httpGet - bad server response : $url\n");
	}
	list(, $httpVersion, $code, $message, $headers, , $content) = $parts;
	
	$headerLines = explode("\r\n", $headers);
	$headers = array();
	reset($headerLines);
	while (list(, $headerLine) = each($headerLines)) {
		if ($headerLine == "") break;
		if (preg_match('/^(.+?): (.*)$/s', $headerLine, $parts)) {
			list(, $headerName, $headerValue) = $parts;
			$headers[$headerName] = $headerValue;
		} else {
			$headers[$headerLine] = "";
		}
	}
	
	return array($httpVersion, $code, $message, $headers, $content);
}

/*
 * httpGet : minimalist GET request
 * $url : document HTTP URL
 * $ua : user agent
 * $referer : referer
 * $cookies : associative array {cookie name => cookie value}
 * returns : (response http version, status code, status message,
 *             associative array {header name => header value}, response content)
 */
function httpGet($url, $ua, $referer, $cookies) {
	list($host, $port, $path) = parseUrl($url);
	
	$request = "GET $path HTTP/1.1";
	$request .= commonHeaders($host, $port, $ua, $referer, $cookies);
	$request .= "\r\n\r\n";
	
	//echo "$request";
	
	return parseResponse(connexion($host, $port, $request));
}

/*
 * httpPost : minimalist POST request
 * $url : document HTTP URL
 * $content : POST data
 * $contentType : content type of the POST data
 * $ua : user agent
 * $referer : referer
 * $cookies : associative array {cookie name => cookie value}
 * returns : (response http version, status code, status message,
 *             associative array {header name => header value}, response content)
 */
function httpPost($url, $content, $contentType, $ua, $referer, $cookies) {
	list($host, $port, $path) = parseUrl($url);
	
	$request = "POST $path HTTP/1.1";
	$request .= "\r\nContent-Length: ".strlen($content);
	$request .= "\r\nContent-Type: $contentType";
	$request .= commonHeaders($host, $port, $ua, $referer, $cookies);
	$request .= "\r\n\r\n$content";
	
	//echo "$request\n\n";
	
	return parseResponse(connexion($host, $port, $request));
}

?>