<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Cookies related functions
 **************************************************/

/*
 * Special cookies
 */
$specialCookies = array(
	"postprefix" => "Post prefix",
	"uaprefix" => "UA prefix"
);

/*
* getSpecialCookieName : return special cookie long name
* $board : board name
* $cookieName : special cookie short name
* returns : special cookie name, related to the board
*/
function getSpecialCookieName($board, $cookieName) {
	return "$board-$cookieName";
}

/*
* getCookieName : return cookie long name
* $board : board name
* $cookieName : cookie short name
* returns :  cookie name, related to the board
*/
function getCookieName($board, $cookieName) {
	return "$board--$cookieName";
}

/*
 * selectCookiesForBoard : Select cookies related to a bord, among all defined cookies
 * $board : board name
 * $boardCookies : array containings the name of the cookies used by the board
 * $globalCookies : defined cookies
 */
function selectCookiesForBoard($board, $boardCookies, $globalCookies) {
	$cookies = array();
	foreach($boardCookies as $cookieName) {
		if ($globalCookies["$board--$cookieName"] != "") {
			$cookies[$cookieName] = $globalCookies["$board--$cookieName"];
		}
	}
	return $cookies;
}

/*
 * getUa : returns the user agent depending on cookies and real user agent
 * $headers : headers (CGI) of the HTTP request
 * $cookies : cookies of the HTTP request
 * $board : board name
 */
function getUa($headers, $cookies, $board) {
	return isset($cookies["$board-uaprefix"])
		? $cookies["$board-uaprefix"]." - ".$headers["HTTP_USER_AGENT"]
		: (isset($cookies["uaprefix"])
			? $cookies["uaprefix"]." - ".$headers["HTTP_USER_AGENT"]
			: $headers["HTTP_USER_AGENT"]);
}

/*
 * getPostPrefix : returns the prefix to apply to each posted message (before editing)
 * $cookies : cookies of the HTTP request
 * $board : board name
 */
function getPostPrefix($cookies, $board) {
	return isset($cookies["$board-postprefix"])
		? $cookies["$board-postprefix"]." "
		: (isset($cookies["postprefix"])
			? $cookies["postprefix"]." "
			: "");
}

?>
