<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Common functions
 **************************************************/

/*
 * Encapsulates board parameters
 */
class Board {
	var $backendUrl;
	var $postUrl;
	var $postData;
	var $backendType;
	var $cookies;

	/*
	 * Board : Creates a new board parameters encapsulation
	 * $backendUrl : backend URL
	 * $postUrl : message post URL
	 * $postData : post data format (a string where '%s' represents the message to post)
	 * $backendType : backend type (BACKEND_tagsNotEncoded or BACKEND_tagsEncodeds)
	 * $cookies : array containings the name of the cookies used by the board
	 */
	function Board($backendUrl, $postUrl, $postData, $backendType, $cookies) {
		$this->backend_url = $backendUrl;
		$this->post_url = $postUrl;
		$this->postData = $postData;
		$this->backend_type = $backendType;
		$this->cookies = $cookies;
	}
}

/*
 * Backend types
 */
define("BACKEND_tagsNotEncoded", 1);
define("BACKEND_tagsEncodeds", 2);
define("BACKEND_tagsSemiEncodeds", 4);

/*
 * getBoard : returns the board name, or ends the script if either there is no board name specified, or the board name does not correspond to an available board
 * $vars : $HTTP_GET_VARS
 * $boards : boards
 * returns : a valid board name
 */
function getBoardName($vars, $boards) {
	if (!isset($vars["board"])) {
		die("no board specified !");
	}
	if (!isset($boards[$vars["board"]])) {
		die("invalid board name !");
	}
	return $vars["board"];
}

/*
 * wmlHeader : Prints WML header
 */
function wmlHeader() {
	header("Content-Type: text/vnd.wap.wml");
	echo '<?xml version="1.0" encoding="iso-8859-1"?>'."\n";
	echo '<!DOCTYPE wml PUBLIC "-//WAPFORUM//DTD WML 1.1//EN" "http://www.wapforum.org/DTD/wml_1.1.xml">'."\n";
}

/*
 * decodeXML : decodes '<', '>', '"' and '&' characters in the string $s
 */
function decodeXML($s) {
	return preg_replace(
		array(',&lt;,', ',&gt;,', ',&quot;,', ',&amp;,'),
		array('<', '>', '"', '&'),
		$s
	);
}

/*
 * encodeXML : encodes '<', '>', '"' and '&' characters in the XML string $s
 */
function encodeXML($s) {
	return preg_replace(
		array(',&,', ',<,', ',>,', ',",'),
		array('&amp;', '&lt;', '&gt;', '&quot;'),
		$s
	);
}

/*
 * unescape : unescapes special characters in the string $s
 */
function unescape($s) {
	return preg_replace(
		array(',\\\\\',', ',\\\\",', ',\\\\\\\\,', ',\\\\a,', ',\\\\n,', ',\\\\r,', ',\\\\t,', ',\\\\f,', ',\\\\e,'),
		array("'", "\"", "\\", "\a", "\n", "\r", "\t", "\f", "\e"),
		$s
	);
}

/*
 * join_cdr : Join list items with a string, ignoring first item
 * $glue : string to add between each item
 * $list : the list to join (must be a [0; count-1] array)
 */
function join_cdr($glue, $list) {
	if (count($list) < 2) return "";
	$s = $list[1];
	for ($i = 2 ; $i < count($list) ; $i++) {
		$s .= $glue.$list[$i];
	}
	return $s;
}

/*
 * join_cons : Join list items with a string, adding an heading item
 * $glue : string to add between each item
 * $car : head of the list
 * $cdr : the list to join
 */
function join_cons($glue, $car, $cdr) {
	if (count($cdr) == 0) {
		return $car;
	} else {
		return $car.$glue.join($glue, $cdr);
	}
}

?>
