<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Backend analyser
 **************************************************/

include("lib/entities.php");

/*
 * analysesBackend : analyses the XML backend and returns its logical content
 * $xmlContent : XML content of the backend
 * $backend_type : backend type (BACKEND_tagsNotEncoded or BACKEND_tagsEncodeds)
 * returns : list($id, $clock, $ua, $login, $message)
 */
function analyseBackend($xmlContent, $backend_type) {
	preg_match_all(",<post (.*?)>(.*?)</post>,s", $xmlContent, $xmlPosts);
	
	$_id = array();
	$_clock = array();
	$_ua = array();
	$_login = array();
	$_message = array();
	
	for ($i = 0 ; $i < count($xmlPosts[1]) ; $i++) {
		preg_match(",id=[\"'](\d+)[\"'],", $xmlPosts[1][$i], $parts);
		list(, $id) = $parts;
		
		preg_match(",time=[\"']\d+(\d\d)(\d\d)(\d\d)[\"'],", $xmlPosts[1][$i], $parts);
		list(, $hours, $minutes, $seconds) = $parts;
		
		preg_match(",<info>(.*)</info>,", $xmlPosts[2][$i], $parts);
		list(, $ua) = $parts;
		
		preg_match(",<login>(.*)</login>,", $xmlPosts[2][$i], $parts);
		list(, $login) = $parts;
		
		preg_match(",<message>(.*)</message>,", $xmlPosts[2][$i], $parts);
		list(, $message) = $parts;
		
		if ($backend_type == BACKEND_tagsEncodeds) {
			$message = decodeXML($message);
		} else if ($backend_type == BACKEND_tagsSemiEncodeds) {
			$message = preg_replace(
				array(',&lt;(/?)u&gt;,', ',&lt;(/?)s&gt;,', ',&lt;(/?)span.*?&gt;,', ',&lt;(/?)i&gt;,', ',&lt;(/?)b&gt;,', ',&lt;a href=&quot;(.*?)&quot;&gt;(.*?)&lt;/a&gt;,'),
				array('<$1u>', '<$1u>', '<$1u>', '<$1i>', '<$1b>', '<a href="$1">$2</a>'),
				$message
			);
		}
		
		/*
		$message = preg_replace(
			array(",<a\s.*?href=[\"'](.*?)[\"'].*?>,i", ',</a>,i'),
			array('<anchor><go href="$1"/>', '</anchor>'),
			$message
		);
		*/
		
		$message = preg_replace(
			array(',<!--.*?-->,', ',(<a\b.*?>)((<.*?>|\[)*)(.*?)((<.*?>|\])*)(</a>),', ',<(/?)span.*?>,', ',<(/?)s>,', ',<(/?)tt>,', ',&lt;(/?)tt&gt;,'),
			array('', '$2$1$4$7$5', '<$1u>', '<$1u>', '<$1small>', '<$1small>'),
			$message
		);
		
		array_push($_id, $id);
		array_push($_clock, "$hours:$minutes:$seconds");
		array_push($_ua, decodeEntities($ua));
		array_push($_login, decodeEntities($login));
		array_push($_message, decodeEntities($message));
		
		//echo "$id $hours:$minutes:$seconds $login $ua $message\n";
		
	}
	
	return array($_id, $_clock, $_ua, $_login, $_message);
}

?>
