<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Cookies display
 **************************************************/

include("lib/commons.php");
include("lib/cookies.php");
include("lib/nxpt.class.php");
include("./config.php");

$board = getBoardName($HTTP_GET_VARS, $boards);

$specialCookieName = array();
$specialCookieDisplay = array();
$specialCookieValue = array();
foreach ($specialCookies as $specialCookie => $display) {
	array_push($specialCookieName, $specialCookie);
	array_push($specialCookieDisplay, $display);
	array_push($specialCookieValue, $HTTP_COOKIE_VARS[getSpecialCookieName($board, $specialCookie)]);
}

$cookieName = array();
$cookieValue = array();
foreach($boards[$board]->cookies as $cookie) {
	array_push($cookieName, $cookie);
	array_push($cookieValue, $HTTP_COOKIE_VARS[getCookieName($board, $cookie)]);
}

wmlHeader();

$nxpt = new nxpt;
$nxpt->nxpt_cache_path("cache");
$nxpt->assign("board", $board);
$nxpt->assign("specialCookieName", $specialCookieName);
$nxpt->assign("specialCookieDisplay", $specialCookieDisplay);
$nxpt->assign("specialCookieValue", $specialCookieValue);
$nxpt->assign("cookieName", $cookieName);
$nxpt->assign("cookieValue", $cookieValue);
$nxpt->display("template/cookies.xml");

?>
