<?php

/*
* Copyright (c) 2004 2xplop <2xplop at bluewin.ch>
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this
* software and associated documentation files (the "Software"), to deal in the Software
* without restriction, including without limitation the rights to use, copy, modify, merge,
* publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
* to whom the Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or substantial
* portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
* PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
* FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

/*
Plop!
*/
class nxpt_process {

	var $templates_include;
	var $nxpt_compiler;

	function nxpt_process() {
		$this->templates_include = array();
		$this->nxpt_compiler = new nxpt_compiler;
	}

	function nxpt_process_template($template_name, $nxpt_config) {
		/*Et hop, un joli petit travail a faire :o*/
		array_push($this->templates_include, $template_name);
		while (list ( , $template_name) = each($this->templates_include)) {
			$nxpt_template = new nxpt_template;
			$nxpt_template->template_absolute_path = $template_name;
			$nxpt_template->nxpt_cache_path = $nxpt_config->nxpt_cache_path;
			$this->nxpt_compiler->process($nxpt_template, '');
			$nxpt_template = $this->nxpt_compiler->nxpt_template;
			$this->nxpt_process_add_include($nxpt_template->template_include);
			$this->nxpt_save_template($nxpt_template, '');
		}
	}

	function nxpt_process_add_include($include_array) {
		foreach ($include_array as $template_path) {
			if (!in_array($template_path, $this->templates_include)) {
				array_push($this->templates_include, $template_path);
			}
		}
	}

	function nxpt_save_template($template, $charset_out) {
		//print_r($template->template_compiled);
		$file_compiled_template = fopen($template->nxpt_cache_path.nxpt_utils::replace_slash_dot($template->template_absolute_path).'-compiled', 'w');
		fwrite($file_compiled_template, $template->template_compiled);
		fclose($file_compiled_template);
	}
}

/*********************************************************************/

class nxpt_template {

	var $template_absolute_path;
	var $nxpt_cache_path;
	var $template_include;
	var $template_compiled;

	function nxpt_template() {
		$this->template_include = array();
		$this->template_compiled = '';
	}
}

/*********************************************************************/

class nxpt_compiler {

	var $nxpt_compiler_xml_parser;
	var $nxpt_template;
	var $nxpt_foreach_var;
	var $nxpt_redirect_output;
	var $nxpt_set_var;
	//----- oui, c'est gorait... :-/ TODO: les virer [:gratgrat]
	var $nxpt_compiler_w_c_o_lock;
	var $nxpt_print_open;
	var $nxpt_is_void_element;
	var $nxpt_is_after_open_element;
	var $strip_whitespace;
	//-----

	function nxpt_compiler() {
		$this->nxpt_foreach_var = array();
		$this->nxpt_redirect_output = array('template');
		$this->nxpt_set_var = array();
		$this->nxpt_compiler_w_c_o_lock = false;
		$this->nxpt_print_open = false;
		$this->nxpt_is_void_element = false;
		$this->nxpt_is_after_open_element = false;
		//je sais sai pas bien
		$this->strip_whitespace = 'false';
	}

	function process($nxpt_template, $charset_in) {
		$this->nxpt_template = $nxpt_template;
		$this->nxpt_template->template_compiled .= '<?php ';
		$this->compile_template($charset_in);
		xml_parser_free($this->nxpt_compiler_xml_parser);
		$this->nxpt_template->template_compiled .= '?>';
		$this->nxpt_compiler();
	}

	function compile_template($charset_in) {
		$this->nxpt_compiler_xml_parser = xml_parser_create('ISO-8859-1');
		xml_set_object($this->nxpt_compiler_xml_parser, $this);
		xml_parser_set_option($this->nxpt_compiler_xml_parser, XML_OPTION_CASE_FOLDING, false);
		xml_set_element_handler($this->nxpt_compiler_xml_parser, 'startElement', 'endElement');
		xml_set_character_data_handler($this->nxpt_compiler_xml_parser, 'characterData');
		if (!($fp = fopen($this->nxpt_template->template_absolute_path, 'r'))) {
			$error_type = 'Input';
			$error_message = 'Could not open XML input';
			$template = $this->nxpt_template->template_absolute_path;
			die(nxpt_errors::error($error_type, $error_message, $template));
		}
		while ($data = fread($fp, 4096)) {
			//hack gruick gruick! ^^
			$data = str_replace('&', '&amp;', $data);
			//print $data;
			if (!xml_parse($this->nxpt_compiler_xml_parser, $data, feof($fp))) {
				$error_type = 'XML error';
				$template = $this->nxpt_template->template_absolute_path;
				$error_message = xml_error_string(xml_get_error_code($this->nxpt_compiler_xml_parser)).' at line '.xml_get_current_line_number($this->nxpt_compiler_xml_parser);
				die(nxpt_errors::error($error_type, $error_message, $template));
			}
		}
	}

	function startElement($parser, $name, $attrs) {
		$this->nxpt_compiler_w_c_o_lock = false;
		$template_name = $this->nxpt_template->template_absolute_path;
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		// a virer on peut le faire a coup d'explode :o
		if (!preg_match('/^nxpt:/', $name)) {
			if($this->nxpt_is_after_open_element == true) {
				$this->nxpt_template->template_compiled .= '>';
			}
			$this->nxpt_is_after_open_element = true;
			$this->nxpt_is_void_element = true;
			if($this->nxpt_print_open == false) {
				$this->nxpt_template->template_compiled .= '$'.end($this->nxpt_redirect_output).' .= \'';
				$this->nxpt_print_open = true;
			}
			$this->non_nxpt_element_start($name, $attrs);
		} else {
			//print_r($name);
			if($this->nxpt_is_void_element == true) {
				$this->nxpt_template->template_compiled .= '>';
			}
			$this->nxpt_is_void_element = false;
			if($this->nxpt_print_open == true) {
				$this->nxpt_template->template_compiled .= '\';';
				$this->nxpt_print_open = false;
			}
			switch ($name) {
				case 'nxpt:template':

					$version = nxpt_process_utils::check_attr($attrs, 'version', $name, $line, $template_name);
					if($version != '0.0.3') {
						$error_type = 'template version (nxpt)';
						$error_message = 'version du template n\'est pas correcte ('.$version.')! Doit etre: <strong>0.0.3</strong>';
						die(nxpt_errors::error($error_type, $error_message, $template_name));
						}
					$uri_nxpt_namespace = nxpt_process_utils::check_attr($attrs, 'xmlns:nxpt', $name, $line, $template_name);
					if($uri_nxpt_namespace != 'http://phplop.tuxfamily.org/nxpt') {
						$error_type = 'xmlns url (nxpt)';
						$error_message = 'doit etre http://phplop.tuxfamily.org/nxpt';
						die(nxpt_errors::error($error_type, $error_message, $template_name));
					}
					if(array_key_exists('stripwhitespace',$attrs)) {
						$valeur_attribut = $attrs['stripwhitespace'];
						if($valeur_attribut != 'true' && $valeur_attribut != 'false') {
							$error_type = 'attribut stripwhitespace';
							$error_message = 'valeur doit etre true ou false, pas '.$valeur_attribut;
							die(nxpt_errors::error($error_type, $error_message, $template_name));
						}
						$this->strip_whitespace = $valeur_attribut;
					}
					break;

				case 'nxpt:out':
					$this->nxpt_out_start($attrs, $name);
					break;

				case 'nxpt:if':
					$this->nxpt_template->template_compiled .= 'if('.nxpt_process_utils::attr_test($attrs, $name, $line, $template_name).') {';
					break;

				case 'nxpt:when':
					$this->nxpt_template->template_compiled .= 'elseif('.nxpt_process_utils::attr_test($attrs, $name, $line, $template_name).') {';
					break;

				case 'nxpt:otherwise':
					$this->nxpt_template->template_compiled .= 'else {';
					break;

				case 'nxpt:choose':
					$this->nxpt_template->template_compiled .= 'if(false) {}';
					$this->nxpt_compiler_w_c_o_lock = true;
					break;

				case 'nxpt:foreach':
					$this->nxpt_foreach_start($attrs, $name);
					break;

				case 'nxpt:include':
					$this->nxpt_include_start($attrs, $name);
					break;

				case 'nxpt:break':
					$this->nxpt_break_start($attrs, $name);
					break;

				case 'nxpt:next':
					$this->nxpt_next_start($attrs, $name);
					break;

				case 'nxpt:redirectoutput':
					$this->nxpt_redirectoutput_start($attrs, $name);
					break;

				case 'nxpt:set':
					$this->nxpt_set_start($attrs, $name);
					break;

				case 'nxpt:remove':
					$this->nxpt_remove_start($attrs, $name);
					break;
			}
		}
		//print("--START_ELEMENT--\n");
		//print_r($this->nxpt_template->template_compiled);
		//print("\n--------------\n");
	}

	function endElement($parser, $name) {
		//print($name)."\n";
		$this->nxpt_compiler_w_c_o_lock = false;
		if (!preg_match('/^nxpt:/', $name)) {
			$this->nxpt_is_after_open_element = false;
			if($this->nxpt_print_open == true) {
				if($this->nxpt_is_void_element == true) {
					$this->nxpt_template->template_compiled .= ' />';
					$this->nxpt_is_void_element = false;
				} else {
					$this->nxpt_template->template_compiled .= '</'.$name.'>';
				}
			} else {
				$this->nxpt_template->template_compiled .='$'.end($this->nxpt_redirect_output).'.= \'</'.$name.'>';
				$this->nxpt_print_open = true;
			}
		} else {
			if($this->nxpt_print_open == true) {
				$this->nxpt_template->template_compiled .= '\';';
				$this->nxpt_print_open = false;
			}
			switch($name) {
				case 'nxpt:if':
					$this->nxpt_close_bracket_end();
					break;

				case 'nxpt:when':
					$this->nxpt_compiler_w_c_o_lock = true;
					$this->nxpt_close_bracket_end();
					break;

				case 'nxpt:otherwise':
					$this->nxpt_compiler_w_c_o_lock = true;
					$this->nxpt_close_bracket_end();
					break;

				case 'nxpt:foreach':
					$this->nxpt_close_bracket_end();
					array_pop($this->nxpt_foreach_var);
					break;

				case 'nxpt:redirectoutput':
					array_pop($this->nxpt_redirect_output);
			}
		}
		//print("--END_ELEMENT--\n");
		//print_r($this->nxpt_template->template_compiled);
		//print("\n--------------\n");
	}

	function characterData($parser, $data) {
		//print_r($data);
		//print("--CHAR_DATA_BEFORE--\n");
		//print_r($this->nxpt_template->template_compiled);
		//print("\n--------------\n");
		$this->nxpt_is_after_open_element = false;
		if($this->nxpt_compiler_w_c_o_lock == false) {
			if($this->nxpt_is_void_element == true) {
				$this->nxpt_template->template_compiled .= '>';
			}
			$this->nxpt_is_void_element = false;
			$data = nxpt_process_utils::add_slashouille($data);
			//print_r($data);
			if($this->nxpt_print_open == false) {
				//vilain bug!
				//$this->nxpt_template->template_compiled .= '$'.end($this->nxpt_redirect_output).' .= \''.$data;
				$this->nxpt_template->template_compiled .= '$'.end($this->nxpt_redirect_output).' .= \'';
				$this->nxpt_print_open = true;
			}
			//print_r($data);
			//un'autre systeme ?
			//on efface les \s inutiles, mais dans certains <elements> ces caracteres sont utiles (<pre>, blah blah)
			if($this->strip_whitespace == 'false') {
				$this->nxpt_template->template_compiled .= $data;
				//print_r($data);
			} else {
				if(preg_match('/[\n\r\f]+/',$data)) {
				} else {
					$this->nxpt_template->template_compiled .= trim($data,"\t");
				}
			}
		}
		//print_r($data);
		//print("--CHAR_DATA_AFTER--\n");
		//print_r($this->nxpt_template->template_compiled);
		//print("\n--------------\n");
	}

	function non_nxpt_element_start($name, $attrs) {
		$this->nxpt_template->template_compiled .= '<'.$name;
		$tmp_string = '';
		foreach ($attrs as $key => $value) {
			$value = nxpt_process_utils::add_slashouille($value);
			//TODO: a controler que a ne bugge pas, mais a sux toujours, on ne peut passer en 'string' les $,{,} ...
			if(preg_match_all('/\${([^{}$]+)}/',$value,$matches)) {
				foreach ($matches[1] as $expression) {
					$value = str_replace('${'.$expression.'}','\'.'.nxpt_expression::expression($expression).'.\'', $value);
				}
			}
			$tmp_string .=' '.$key.'="'.$value.'"';
		}
		$this->nxpt_template->template_compiled .= $tmp_string;
	}

	function nxpt_close_bracket_end() {
		$this->nxpt_template->template_compiled .= '}';
	}

	function nxpt_out_start($attrs, $name) {
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$expression = nxpt_process_utils::add_slashouille(nxpt_process_utils::check_attr_e($attrs, 'value', $name, $line, $template_name));
		$this->nxpt_template->template_compiled .= '$'.end($this->nxpt_redirect_output).'  .= '.nxpt_expression::expression($expression).';';
	}

	function nxpt_foreach_start($attrs, $name) {
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$begin = nxpt_process_utils::check_attr_e($attrs, 'begin', $name, $line, $template_name);
		$end = nxpt_process_utils::check_attr_e($attrs, 'end', $name, $line, $template_name);
		$var = nxpt_process_utils::check_attr_e($attrs, 'var', $name, $line, $template_name);
		array_push($this->nxpt_foreach_var, $var);
		$begin = nxpt_expression::expression($begin);
		$end = nxpt_expression::expression($end);
		$this->nxpt_template->template_compiled .= 'for($'.$var.'='.$begin.';$'.$var.'<'.$end.';$'.$var.'++){';
	}

	function nxpt_include_start($attrs, $name) {
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$template = nxpt_process_utils::check_attr($attrs, 'template', $name, $line, $template_name);
		$path_parts = pathinfo($this->nxpt_template->template_absolute_path);
		$path_include = realpath($path_parts['dirname'].'/'.$template);
		if(!file_exists($path_include)) {
			$error_type = 'included template';
			$error_message = $path_parts['dirname'].'/'.$template.' n\'existe pas (ligne '.xml_get_current_line_number($this->nxpt_compiler_xml_parser).')';
			$template = $this->nxpt_template->template_absolute_path;
			die(nxpt_errors::error($error_type, $error_message, $template));
		}
		if(!in_array($path_include, $this->nxpt_template->template_include)) {
			array_push($this->nxpt_template->template_include, $path_include);
		}
		$path_include = nxpt_utils::replace_slash_dot($path_include).'-compiled';
		$this->nxpt_template->template_compiled .= 'include(\''.$path_include.'\');';
	}

	function nxpt_break_start($attrs, $name) {
		$this->nxpt_template->template_compiled .= 'break;';
	}

	function nxpt_next_start($attrs, $name) {
		$this->nxpt_template->template_compiled .= 'continue;';
	}

	function nxpt_redirectoutput_start($attrs, $name) {
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$var = nxpt_process_utils::check_attr_e($attrs, 'var', $name, $line, $template_name);
		array_push($this->nxpt_redirect_output, $var);
	}

	function nxpt_set_start($attrs, $name) {
		$value = '';
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$var = nxpt_process_utils::check_attr_e($attrs, 'var', $name, $line, $template_name);
		array_push($this->nxpt_set_var, $var);
		if(array_key_exists('value',$attrs)) {
			$value = nxpt_process_utils::get_expression($attrs['value']);
			$value = nxpt_expression::expression($value);
			$this->nxpt_template->template_compiled .= '$'.$var.'='.$value.';';
		} else {
			$this->nxpt_template->template_compiled .= '$'.$var.'= \'\';';
		}
	}

	function nxpt_remove_start($attrs, $name) {
		$line = xml_get_current_line_number($this->nxpt_compiler_xml_parser);
		$template_name = $this->nxpt_template->template_absolute_path;
		$var = nxpt_process_utils::check_attr_e($attrs, 'var', $name, $line, $template_name);
		if(in_array($var, $this->nxpt_set_var)) {
			//cai gorait, mais a marche :o pas eu le temps de regarder la doc de php [:spamafote]
			$key = array_search($var,$this->nxpt_set_var);
			//TODO: gruick, unset ? [:gratgrat]
			$this->nxpt_set_var[$key] = '';
		}
	}
}

/*********************************************************************/

class nxpt_process_utils {

	function get_expression($string) {
		$tmp = explode('${', $string);
  		$retmp = explode('}', $tmp[1]);
		//TODO erreurs :o
  		return $retmp[0];
	}

	function add_slashouille($data) {
		return str_replace('\'', '\\\'', $data);
	}

	function attr_test($attrs, $name, $line, $template) {
		$expression = nxpt_process_utils::check_attr_e($attrs, 'test', $name, $line, $template);
		$expression = nxpt_process_utils::add_slashouille($expression);
		return nxpt_expression::expression($expression);
	}

	function check_attr($attrs,$key,$name,$line, $template) {
		if(array_key_exists($key, $attrs)) {
			return $attrs[$key];
		} else {
			$error_type = 'attribute error';
			$error_message = nxpt_errors::attribute_msg($key, $name, $line);
			die(nxpt_errors::error($error_type, $error_message, $template));
		}
	}

	function check_attr_e($attrs, $key, $name, $line, $template) {
			$expression = nxpt_process_utils::check_attr($attrs, $key, $name, $line, $template);
			return nxpt_process_utils::get_expression($expression);
	}
}

/*********************************************************************/

class nxpt_errors {

	function error($type, $error, $template) {
		return '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>nxpt  error</title>
<style type="text/css">
html,body {margin:0;font-family:sans-serif}
h1{background-color:#9EB5C7;margin:0;margin-bottom:0.5em; border-bottom:1px dotted black}
p span {font-weight:bold;margin-left:0.5em; padding:2px;} p {margin:0;padding-bottom:1em;}
</style>
</head>
<body>
<h1>&lt;nxpt/&gt; error</h1>
<p><span>template:</span> '.$template.'</p>
<p><span>type:</span> '.$type.'</p>
<p><span>message:</span> '.$error.'</p>
</body>
</html>';
	}

	function attribute_msg($attribute, $tag_name, $line) {
		return 'required attribute \''.$attribute.'\' not specified in &lt;'.$tag_name.'/&gt; at line '.$line;
	}
}

/*********************************************************************/

class nxpt_expression {

	function expression($expression) {
		// /!\ hyper gruiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiick /!\
		//TODO:  gestion des erreurs
		$expression = str_replace('&amp;&amp;', '&&', $expression);
		$expression = str_replace('&lt;', '<', $expression);
		$expression = str_replace('&gt;', '>', $expression);

		$is_string = false;
		$expression_tmp = '(';
		$fooarray = array(',', '(', ')', '[', ']', '||', '&&',
		'!', '>=', '<=', '<', '>', '!=', '==', '+', '*', '/', '-', '+=','%','.','-=','*=','/=','%=','.=');
		//gruick gruick!
		$expression = str_replace(' ','', $expression);
		$expression = str_replace('[', ' [ ', $expression);
		$expression = str_replace(']', ' ] ', $expression);
		$expression = str_replace('(', ' ( ', $expression);
		$expression = str_replace(',',' , ', $expression);
		$expression = str_replace(')', ' ) ', $expression);
		$expression = str_replace('!', ' ! ', $expression);
		$expression = str_replace('&&',' && ', $expression);
		$expression = str_replace('||',' || ', $expression);
		$expression = str_replace('.',' . ', $expression);

		$expression = str_replace('+', ' + ', $expression);
		$expression = str_replace('*', ' * ', $expression);
		$expression = str_replace('/', ' / ', $expression);
		$expression = str_replace('-', ' - ', $expression);
		$expression = str_replace('%', ' % ', $expression);

		$expression = str_replace('>',' > ', $expression);
		$expression = str_replace('<',' < ', $expression);
		$expression = str_replace('< =',' <= ', $expression);
		$expression = str_replace('> =',' >= ', $expression);

		$expression = str_replace('+ =',' += ', $expression);
		$expression = str_replace('- =',' -= ', $expression);
		$expression = str_replace('* =',' *= ', $expression);
		$expression = str_replace('/ =',' /= ', $expression);
		$expression = str_replace('% =',' %= ', $expression);
		$expression = str_replace('. =',' .= ', $expression);

		$expression = str_replace('==',' == ', $expression);
		$expression = str_replace('! =',' != ', $expression);
		$expression = str_replace('\\\'', ' \\\' ', $expression);
		//gruick gruick!
		$expression_array = explode(' ', $expression);

		for($i=0; $i < count($expression_array); $i++) {
		//begin-end string
			$expression_foo = str_replace(' ', '', $expression_array[$i]);
			if ($expression_foo == '\\\'') {
				if($is_string == false) {
					$expression_tmp .= '\'';
					$is_string = true;
				} else {
					$expression_tmp .= '\'';
					$is_string = false;
				}
			}
			//a l'interieur d'un string ?
			elseif($is_string == true) {
				$expression_tmp .= $expression_foo;
			}
			elseif(in_array($expression_foo, $fooarray)) {
				$expression_tmp .= $expression_foo;
			}
			//TODO: regexp a virer (?)
			elseif(!preg_match('/[a-zA-Z,-,_]+/', $expression_foo) && $expression_foo != '') {
				//c'est un int \o/
				$expression_tmp .= $expression_foo;
			}
			//var - arrays - functions
			elseif($expression_foo != '') {
				if(array_key_exists($i+1,$expression_array)) {
				//il y qqchose apres, on controle :o,
				//c'est un array :o
					if($expression_array[$i+1] == '[') {
							$expression_tmp .= '$this->nxpt_assigned_data[\''.$expression_foo.'\']';
					}
					elseif($expression_array[$i+1] == '(') {
					//c'est une fonction :o
						$expression_tmp .= $expression_foo;
					}
					else {
					//c'est un var (ou un array)
						if(in_array($expression_foo, $this->nxpt_foreach_var) || in_array($expression_foo, $this->nxpt_set_var)) {
							$expression_tmp .= '$'.$expression_foo;
						} else {
							$expression_tmp .= 'nxpt_utils::out_assigned_data(\''.$expression_foo.'\',\'${'.$expression_foo.'}\')';
						}
					}
				} else {
				//il n'y a rien apres :'(
					if(in_array($expression_foo, $this->nxpt_foreach_var) || in_array($expression_foo, $this->nxpt_set_var)) {
						$expression_tmp .= '$'.$expression_foo;
					} else {
						$expression_tmp .= 'nxpt_utils::out_assigned_data(\''.$expression_array[$i].'\',\'${'.$expression_array[$i].'}\')';
					}
				}
			}
		}
		return $expression_tmp.')';
	}
}
?>
