<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Basic HTTP client
 **************************************************/

function getmicrotime(){ 
	list($usec, $sec) = explode(" ", microtime()); 
	return ((float)$usec + (float)$sec); 
} 
/*
 * httpGet : minimalist GET request
 * $url : document HTTP URL
 * $ua : user agent
 * $cookies : associative array {cookie name => cookie value}
 * returns : (response http version, status code, status message,
 *             associative array {header name => header value}, response content)
 */
function httpGet($url, $ua, $cookies) {
	if (! preg_match(',^http://(.+?)(:(\d+))?(/.*)$,', $url, $parts)) {
		echo "httpGet - bad url : $url\n";
		return "";
	}
	list(, $host, , $port, $path) = $parts;
	if ($port == "") {
		$port = 80;
	}
	
	$fh = fsockopen($host, $port);
	if(!$fh) {
		echo "httpGet - unable to connect to $host:$port\n";
		return "";
	}
	
	$request = "GET $path HTTP/1.1";
	$request .= "\r\nHost: $host";
	if ($port != 80) $request .= ":$port";
	$request .= "\r\nConnection: close";
	$request .= "\r\nCache-Control: no-cache";
	$request .= "\r\nUser-Agent: $ua";
	$firstcookie = true;
	reset($cookies);
	while (list($name, $value) = each($cookies)) {
		if ($firstcookie) {
			$request .= "\r\nCookie: $name=$value";
			$firstcookie = false;
		} else {
			$request .= ";$name=$value";
		}
	}
	$request .= "\r\n\r\n";
	
	//echo "$request";
	
	fputs($fh, $request);
	$response = "";
	$buf = "";
	while (!feof($fh)) {
		$buf = fgets($fh, 256);
		$response .= $buf;
	}
	fclose($fh);
	
	if (! preg_match(',^HTTP/(.+?) (\d+) (.+?)\r\n((.+?\r\n)*?)\r\n(.*)$,s', $response, $parts)) {
		echo "httpGet - bad server response : $url\n";
		return "";
	}
	list(, $httpVersion, $code, $message, $headers, , $content) = $parts;
	
	$headerLines = explode("\r\n", $headers);
	$headers = array();
	reset($headerLines);
	while (list(, $headerLine) = each($headerLines)) {
		if ($headerLine == "") break;
		if (preg_match('/^(.+?): (.*)$/s', $headerLine, $parts)) {
			list(, $headerName, $headerValue) = $parts;
			$headers[$headerName] = $headerValue;
		} else {
			$headers[$headerLine] = "";
		}
	}
	
	return array($httpVersion, $code, $message, $headers, $content);
}

?>