<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * XML entities management
 **************************************************/

/*
 * XML entities
 * data extracted from Jrme Aug's wap gateway (libcook.php) with :
 * perl -n -e 'if (s!^.*preg_replace\( "/(&\w+;)/", "&#(\d+);".*$!\$entity[$2] = "$1";!) { print; }'
 */
$entity = array();
$entity[160] = "&nbsp;";
$entity[161] = "&iexcl;";
$entity[162] = "&cent;";
$entity[163] = "&pound;";
$entity[164] = "&curren;";
$entity[165] = "&yen;";
$entity[166] = "&brvbar;";
$entity[167] = "&sect;";
$entity[168] = "&uml;";
$entity[169] = "&copy;";
$entity[170] = "&ordf;";
$entity[171] = "&laquo;";
$entity[172] = "&not;";
$entity[173] = "&shy;";
$entity[174] = "&reg;";
$entity[175] = "&macr;";
$entity[176] = "&deg;";
$entity[177] = "&plusmn;";
$entity[178] = "&sup2;";
$entity[179] = "&sup3;";
$entity[180] = "&acute;";
$entity[181] = "&micro;";
$entity[182] = "&para;";
$entity[183] = "&middot;";
$entity[184] = "&cedil;";
$entity[185] = "&sup1;";
$entity[186] = "&ordm;";
$entity[187] = "&raquo;";
$entity[188] = "&frac14;";
$entity[189] = "&frac12;";
$entity[190] = "&frac34;";
$entity[191] = "&iquest;";
$entity[192] = "&Agrave;";
$entity[193] = "&Aacute;";
$entity[194] = "&Acirc;";
$entity[195] = "&Atilde;";
$entity[196] = "&Auml;";
$entity[197] = "&Aring;";
$entity[198] = "&AElig;";
$entity[199] = "&Ccedil;";
$entity[200] = "&Egrave;";
$entity[201] = "&Eacute;";
$entity[202] = "&Ecirc;";
$entity[203] = "&Euml;";
$entity[204] = "&Igrave;";
$entity[205] = "&Iacute;";
$entity[206] = "&Icirc;";
$entity[207] = "&Iuml;";
$entity[208] = "&ETH;";
$entity[209] = "&Ntilde;";
$entity[210] = "&Ograve;";
$entity[211] = "&Oacute;";
$entity[212] = "&Ocirc;";
$entity[213] = "&Otilde;";
$entity[214] = "&Ouml;";
$entity[215] = "&times;";
$entity[216] = "&Oslash;";
$entity[217] = "&Ugrave;";
$entity[218] = "&Uacute;";
$entity[219] = "&Ucirc;";
$entity[220] = "&Uuml;";
$entity[221] = "&Yacute;";
$entity[222] = "&THORN;";
$entity[223] = "&szlig;";
$entity[224] = "&agrave;";
$entity[225] = "&aacute;";
$entity[226] = "&acirc;";
$entity[227] = "&atilde;";
$entity[228] = "&auml;";
$entity[229] = "&aring;";
$entity[230] = "&aelig;";
$entity[231] = "&ccedil;";
$entity[232] = "&egrave;";
$entity[233] = "&eacute;";
$entity[234] = "&ecirc;";
$entity[235] = "&euml;";
$entity[236] = "&igrave;";
$entity[237] = "&iacute;";
$entity[238] = "&icirc;";
$entity[239] = "&iuml;";
$entity[240] = "&eth;";
$entity[241] = "&ntilde;";
$entity[242] = "&ograve;";
$entity[243] = "&oacute;";
$entity[244] = "&ocirc;";
$entity[245] = "&otilde;";
$entity[246] = "&ouml;";
$entity[247] = "&divide;";
$entity[248] = "&oslash;";
$entity[249] = "&ugrave;";
$entity[250] = "&uacute;";
$entity[251] = "&ucirc;";
$entity[252] = "&uuml;";
$entity[253] = "&yacute;";
$entity[254] = "&thorn;";
$entity[255] = "&yuml;";

/*
 * reencodeEntities : remplaces entities with digital value
 * $s : string to reencode
 * return : reencoded string
 */
function reencodeEntities($s) {
global $entity;
	reset($entity);
	while (list($num, $name) = each($entity)) {
		$s = preg_replace("/$name/", "&#$num;", $s);
	}
	return $s;
}

/*
 * decodeEntities : remplaces entities with corresponding characters
 * $s : string to decode
 * return : decoded string
 */
function decodeEntities($s) {
global $entity;
	reset($entity);
	while (list($num, $name) = each($entity)) {
		$s = preg_replace("/$name/e", "chr($num)", $s);
	}
	return $s;
}

?>
