<?php
/*
 * chouchenn mobileboards
 * Copyright (c) 2004 olo <mobileboards at olivierl dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**************************************************
 * Message edition (before sending)
 **************************************************/

include("lib/commons.php");
include("lib/httpclient.php");
include("lib/backendanalyser.php");
include("lib/nxpt.class.php");
include("./config.php");

$board = getBoardName($HTTP_GET_VARS, $boards);
$id = $HTTP_GET_VARS["id"];
$clock = $HTTP_GET_VARS["clock"];

$ua = "";
$login = "";
$message = "";

if (isset($id)) {
	list($httpVersion, $statusCode, $statusMessage, $headers, $content) = httpGet(
		$boards[$board]->backend_url,
		$_SERVER["HTTP_USER_AGENT"],
		"",
		selectCookiesForBoard($board, $boards[$board]->cookies, $HTTP_COOKIE_VARS)
	);
	
	list($_id, $_clock, $_ua, $_login, $_message) = analyseBackend(
		$content,
		$boards[$board]->backend_type
	);
	
	for ( $i = 0 ; i < count($_id) ; $i++) {
		if ($_id[$i] < $id) break;
		if ($_id[$i] == $id) {
			$clock = $_clock[$i];
			$ua = $_ua[$i];
			$login = $_login[$i];
			$message = $_message[$i];
			break;
		}
	}
}

wmlHeader();

$nxpt = new nxpt;
$nxpt->nxpt_cache_path("cache");
$nxpt->assign("board", $board);
$nxpt->assign("clock", isset($clock) ? "$clock " : "");
$nxpt->assign("ua", $ua);
$nxpt->assign("login", $login);
$nxpt->assign("message", $message);
$nxpt->display("template/edit.xml");

?>
