#!/usr/bin/perl -Tw

# chouchenn dibot
# Copyright (c) 2004 olo <dibot at olivierl dot org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use English;

use botconfig;

use Time::localtime;

use LWP;
use URI::URL;
use HTTP::Cookies;
use HTTP::Request::Common qw(POST);

package libbot;

############################################################
# fournit une heure formate
#   paramtre d'entre :
#     - date/heure en secondes d'Epoch (optionnel)
#   paramtre de sortie :
#     - heure au format "hh:mm:ss"
############################################################
sub getTime(;$) {
	my $tm = &Time::localtime::localtime;
	return two($tm->hour).":".two($tm->min).":".two($tm->sec);
}

############################################################
# fournit un nombre format sur 2 chiffres
#   paramtre d'entre :
#     - un nombre
#   paramtre de sortie :
#     - les 2 chiffres dcimaux de poids faible
############################################################
sub two($) {
	return substr("0$English::ARG[0]", -2);
}

############################################################
# poste un message
#   paramtres d'entre :
#     - message  poster
#     - pointeur sur la tribune (hashtable) o poster
#   paramtre de sortie :
#     - succs (boolen)
############################################################
sub post($$) {
	my $message = shift;
	my $boardref = shift;
	my %board = %$boardref;
	
	my $ua = new LWP::UserAgent;
	$ua->agent($board{'user_agent'});
	my $cookie_jar = new HTTP::Cookies();
	my ($cookieName, $cookieValue);
	while (($cookieName, $cookieValue) = each(%{$board{'cookies'}})) {
		$cookie_jar->set_cookie(
			"2",
			$cookieName,
			$cookieValue,
			'/',
			$board{'root_url'},
			#80, false, false, -1, false
		);
	}
	$ua->cookie_jar($cookie_jar);
	$ua->env_proxy() if $botconfig::use_env_proxy;
	$ua->proxy('http', $botconfig::http_proxy) if $botconfig::http_proxy;
	$ua->no_proxy(@botconfig::no_proxy) if $botconfig::no_proxy;
	$ua->timeout($botconfig::http_timeout) if $botconfig::http_timeout;
	
	my $url = new URI::URL("http://".$board{'root_url'}."/".$board{'post_url'});
	my $req = HTTP::Request::Common::POST($url, ['message' => $message]);
	my $resp = $ua->simple_request($req);
	my $success = $resp->is_success || $resp->is_redirect;
	return $success;
}

return 1;
